 <?php

 class Webservice_model extends CI_Model {

      function __construct() {

          parent::__construct();
          date_default_timezone_set('Asia/Kolkata');

    }

    public function join_has_driver($request){
      $result = array('status' => 'error');
      $query = $this->db->where('unique_id', $request['auth'])->get('auth_table');
      if(empty($query)){
            return $result;
      }
      if ($query->num_rows() <= 0) {
            return $result;
      }

      $rs = $query->row();
      $id = $rs->member_id;
      $data = array('users_id' =>$id,
          'profile_pic' =>$request['picture'],
          'id_proof' =>$request['car_id'],
          'car_front' =>$request['car_front'],
          'car_back' =>$request['car_back']);

      $res = $this->db->insert('drivers',$data);
      if($res){
            $result = array('status' => 'success');
      } else {
            $result = array('status' => 'error','message'=>'Already Exist');
      }
      return $result;
}

public function update_driver_location($request) {

      $query = $this->db->where('unique_id', $request['auth'])->get('auth_table');

      if ($query->num_rows() > 0) {

            $rs = $query->row();

            $id = $rs->member_id;

            $data = array('driver_lat' => $request['latitude'],
                      'driver_lng' => $request['longitude']);

            $result = $this->db->where('users_id', $id)->update('drivers', $data);
            

            return $result;

      } else {

            return false;

      }

}

public function registration($data) {


      $num = $this->db->where('email_id', $data['email'])->get('users')->num_rows();

      if($num > 0) {

            $result = array('status' => 'error', 'message' => 'Email Already Exists');

      }
      else {

            $unique_id = $this->generate_unique();

            $this->db->insert('users', array('first_name' => $data['first_name'], 
                  'surname' => $data['sur_name'],
                  'email_id' => $data['email'],
                  'password' => md5($data['password']), 
                  'profile_image' => $data['profile_photo'],
                  'phone' => $data['phone'],

                        // 'is_phone_verified' => '1'

            ));
            $user_id = $this->db->insert_id();

            $phone_verified = array(
                  'phone_verified' => '1'
            );

            $this->db->where('users_id', $user_id);
            $this->db->update('user_profile', $phone_verified);


            $data2 = "SELECT * FROM users WHERE id = '$user_id'";

            $query = $this->db->query($data2);

            $rs2 = $query->row();

            $data = array('user_id' => $user_id,
                  'first_name' =>$rs2->first_name,
                  'sur_name' =>$rs2->surname,
                  'phone' => $rs2->phone, 
                  'email'=>$rs2->email_id,
                  'profile_photo'=>$rs2->profile_image);

            $this->EncryptedPatientKey($user_id,$unique_id);

            if ($user_id) {

                  $result = array('status' => 'success', 'user_id' => $user_id, 'auth_token' => $unique_id,'user' => $data,);

            } else {

                  $result = array('status' => 'error');

            }

      }

      return $result;

}

public function generate_unique() {

      $unqe = md5(uniqid(time().mt_rand(), true));

      return $unqe;

}

public function EncryptedPatientKey($user_id,$unique_id) {

      $this->db->insert('auth_table', array('member_id' => $user_id, 'unique_id' => $unique_id));

}

public function check_email_availability($data){

      $num = $this->db->where('email_id', $data['email'])->get('users')->num_rows();
      $email = $data['email'];

      if($num > 0){


            $result = array('status' => 'success', 'data'=> array('email' => $email, 'is_email_avaliable'=>false));

      }
      else{

        $result = array('status' => 'success', 'data'=> array('email' => $email, 'is_email_avaliable'=>true));


  }

  return $result;
}

public function check_phone_availability($data){

      $num = $this->db->where('phone', $data['phone'])->get('users')->num_rows();
      $phone = $data['phone'];
      if($num > 0){



            $result = array('status' => 'success', 'data'=> array('phone' => $phone, 'is_phone_avaliable'=>false));

      }
      else{

            $result = array('status' => 'success', 'data'=> array('phone' => $phone, 'is_phone_avaliable'=>true));

      }

      return $result;
}

public function login($request){

      $this->db->where('email_id', $request['email']);
      $this->db->where('password', md5($request['password']));

      $this->db->where('status', 1);

      $query = $this->db->select('*')->from('users')->join('user_profile','user_profile.users_id = users.id')->get();


      if ($query->num_rows() > 0) {

            $unique_id = $this->generate_unique();

            $rs = $query->row();

            $is_phone_verified = $rs->phone_verified==1?'true':'false';

            $is_driver_status = $rs->is_driver;


                  //$is_phone_verified = $is_phone==1?'true':'false';

            $data = array('user_id' => $rs->id,
                  'first_name' =>$rs->first_name,
                  'sur_name' =>$rs->surname,
                  'phone' => $rs->phone, 
                  'email'=>$rs->email_id,
                  'profile_photo'=>$rs->profile_image,
                  'is_driver' => $is_driver_status==1?'true':'false',
                  'is_phone_verified' => $is_phone_verified 
            );


            $this->EncryptedPatientKey($rs->id,$unique_id);

            $result = array('status' => 'success', 'auth_token' => $unique_id,'user' => $data);

      } else {

           $result = array('status' => 'error');

     }
     return $result;
}

public function forgot_password($data){

      $this->db->where('email_id',$data['email']);

      $query = $this->db->get('users');

      $rs = $query->row();

      if ($rs) {

            $username = $query->first_name;

            $this->load->helper('string');

            $rand_pwd = random_string('alnum', 8);

            $password = array(
                  'password' => md5($rand_pwd)
            );

            $this->db->where('email_id', $data['email']);

            $query = $this->db->update('users', $password);

            if ($query) {

                  $this->load->library('email');
                  $config = Array(
                        'protocol' => 'smtp',
                        'smtp_host' => 'mail.techlabz.in',
                        'smtp_port' => 587,
                                    'smtp_user' => 'no-reply@techlabz.in', // change it to yours
                                    'smtp_pass' => 'k4$_a4%eD?Hi', // change it to yours
                                    'smtp_timeout' => 20,
                                    'mailtype' => 'html',
                                    'charset' => 'iso-8859-1',
                                    'wordwrap' => TRUE);

                  $this->email->initialize($config); 

                  $subject = 'New Mail';
                  
                        //$this->email->set_newline("\r\n");
                  $this->email->from('no-reply@techlabz.in', $settings->title);
                  $this->email->to($data->email);
                  $this->email->subject("Forget Password");
                  $this->email->message("New Password is:".$rand_pwd);
                  $this->email->send();
                  $rs = $this->email->print_debugger();

                  return "EmailSend";

            }

      } 
      else {

            return false;

      }

}


public function update_fcm_token($request) {

      $query = $this->db->where('unique_id', $request['auth'])->get('auth_table');

      if ($query->num_rows() > 0) {

            $rs = $query->row();

            $id = $rs->member_id;

            $data = array('fcm_token' => $request['fcm_token']);

            $result = $this->db->where('users_id', $id)->update('user_profile', $data);

            return $result;

      } else {

            return false;

      }

}

public function categories(){


      $sql = "SELECT id AS category_id,cat_name as category_name,image AS category_image FROM category WHERE status = '1' ";
      $query = $this->db->query($sql);

      if ($query->num_rows() >= 0) {

            $data = $query->result();
            $result = array('status' => 'success','user' => $data);
      }
      else{

            $result = array('status' => 'error');
      }

      return $result;

}

public function get_user_type($request){

      $query = $this->db->where('unique_id', $request['auth'])->get('auth_table');

      if ($query->num_rows() > 0) {

            $rs = $query->row();

            $driver_id = $rs->member_id;

            $sql = "SELECT is_driver,driver_enabled FROM user_profile WHERE users_id = $driver_id";
            $query = $this->db->query($sql);
                  // echo $this->db->last_query();
                  // die;
            $data = $query->result();
           
            $is_driver = $data[0]->is_driver;
            $is_driver_enabled = $data[0]->driver_enabled;



            if($is_driver=="1"){
                  $request['is_driver'] = "true";
            }else{
                  $request['is_driver'] = "false";
            }

            if($is_driver_enabled=="1"){
                  $request['is_driver_enabled'] = "true";
            }else{
                  $request['is_driver_enabled'] = "false";
            }

            $result = array('status' => 'success','data' => $request['is_driver'],'res'=>$request['is_driver_enabled']);

      }else{

            $result = array('status' => 'error');

      }
      return $result;


}

public function set_user_type($request){
  //pr($request);

      $query = $this->db->where('unique_id', $request['auth'])->get('auth_table');

      if ($query->num_rows() > 0) {

            $rs = $query->row();

            $driver_id = $rs->member_id;

            $data = array('is_driver'=>$request['is_driver']);

            $this->db->where('users_id', $driver_id)->update('user_profile', $data);


            $is_driver = $request['is_driver']; 
            if($is_driver=="1"){
                  $request['is_driver'] = "true";
            }else{
                  $request['is_driver'] = "false";
            }
            $result = array('status' => 'success','data' => $request['is_driver']);

      }else{

            $result = array('status' => 'error');

      }
      return $result;

}

public function promotions(){

      $sql = "SELECT id AS promotion_id,promotion_name,image as promotion_image FROM promotions WHERE status = '1' ";
      $query = $this->db->query($sql);
      if ($query->num_rows() >= 0) {

            $data = $query->result();
                  // print_r($data);
                  // exit;
            // for($i=0; $i<count($data);$i++)
            // {
            //       $data[$i]->promotion_name = "promotion";
            // }
            $result = array('status' => 'success','promotions' => $data);
      }
      else{

            $result = array('status' => 'error');
      }

      return $result;

}

public function popular(){

      $sql = "SELECT category.id as popular_id,category.cat_name as popular_name,category.image as popular_image FROM popular JOIN category ON category.id = popular.cat_id WHERE category.status=1 ORDER BY popular.index_no ASC";

      $query = $this->db->query($sql);
      if ($query->num_rows() >= 0) {

            $data = $query->result();
            $result = array('status' => 'success','popular' => $data);
      }
      else{

            $result = array('status' => 'error');
      }

      return $result;

}

public function update_password($request){

      $query = $this->db->where('unique_id', $request['auth'])->get('auth_table');

      if ($query->num_rows() > 0) {
            $rs = $query->row();
            $id = $rs->member_id;
            $query = $this->db->query("SELECT * FROM users 
               WHERE id = '".$id."' AND 
               password ='".md5($request['old_password'])."'");
            if(!empty($query)){
                  $rs = $query->row();
                  if($query->num_rows() <= 0){
                        return array('status' => 'error','message' => 'Password mismatch');
                  }
            }
            $query = $this->db->update('users', array('password'=>md5($request['new_password'])), 
                  array('id'=>$id));
            if($query){
                  return array('status' => 'success');
            }
      }
      return array('status' => 'error','message' => 'No data'); 
}

public function update_phone($request){

      $query = $this->db->where('unique_id', $request['auth'])->get('auth_table');

      if ($query->num_rows() > 0) {

            $rs = $query->row();
                  // print_r($rs);die();

            $id = $rs->member_id;

            $data = "SELECT * FROM users WHERE id = '$id'";


            $query = $this->db->query($data);

            $rs = $query->row();


            if($query->num_rows() <= 0){

                  $result = array('status' => 'error','message' => 'No data');

            }
            else{

                  $phone = array(
                        'phone' => $request['phone']
                  );

                  $this->db->where('id', $id);

                  $query = $this->db->update('users', $phone);

                  $result = array('status' => 'success');

            }

      }else{

            $result = array('status' => 'error','message' => 'No data'); 

      }


      return $result;
}

public function notification_update($request){

      $query = $this->db->where('unique_id', $request['auth'])->get('auth_table');

      if($query->num_rows() > 0){

            $rs = $query->row();

            $driver_id = $rs->member_id;

            $data = array('notification'=>$request['notification_update']);

            $this->db->where('id', $driver_id)->update('users', $data);

            $result = array('status' => 'success','data' => $request['notification_update'],);

      }
      else{
            $result = array('status' => 'error');
      }
      return $result;

}

public function get_user_info($request){
 $result = array();
 $query = $this->db->query("SELECT USR.id,USR.first_name,USR.surname,USR.phone,
     USR.profile_image,USR.notification,USR.email_id,DRV.profile_pic,
     DRV.earnings,UP.phone_verified,UP.email_verified,UP.driver_enabled,
     UP.is_driver,UP.wallet,AP_RATE.rate AS appRate,
     DRV_RATE.rate AS drvRate
     FROM users AS USR
     INNER JOIN auth_table AS AT ON (AT.member_id = USR.id)
     INNER JOIN user_profile AS UP ON (UP.users_id = USR.id)
     LEFT JOIN drivers AS DRV ON (DRV.users_id = USR.id AND DRV.status = '1')
     LEFT JOIN app_rate AS AP_RATE ON (AP_RATE.users_id = USR.id)
     LEFT JOIN driver_rate AS DRV_RATE ON (DRV_RATE.users_id = USR.id)
     WHERE AT.unique_id = '".$request['auth']."' AND USR.status = '1'
     GROUP BY USR.id");
 if($query->num_rows() > 0){
      $userData = $query->row_array();
      $usrOdrCount = $this->db->query("SELECT COUNT(id)
          FROM orders 
          WHERE status = '3' AND users_id = '".$userData."'
          GROUP BY users_id");
      $drvOdrCount = $this->db->query("SELECT COUNT(id)
          FROM orders 
          WHERE status = '3' AND driver_id = '".$userData."'
          GROUP BY  status = '3' driver_id");

      $usrOdrCount = (!empty($usrOdrCount))?$usrOdrCount->row_array():0;
      $drvOdrCount = (!empty($drvOdrCount))?$drvOdrCount->row_array():0;
      $userData['user_oder_count'] = (empty($usrOdrCount))?0:$usrOdrCount;
      $userData['driver_oder_count'] = (empty($drvOdrCount))?0:$drvOdrCount;

      $query = $this->db->select('AVG(NULLIF(rate,0)) as avg_rate')->where('users_id', $userData['id'])->get('user_rate');
      if($query->num_rows() > 0){
          $res = $query->result();
         // pr($res[0]->avg_rate);
          $userData['appRate'] = ceil($res[0]->avg_rate);
       }

       $query1 = $this->db->select('AVG(NULLIF(rate,0)) as avg_rate')->where('driver_id', $userData['id'])->get('driver_rate');
      if($query1->num_rows() > 0){
          $res = $query1->result();
         // pr($res[0]->avg_rate);
          $userData['drvRate'] = ceil($res[0]->avg_rate);
       }



      $respArr = array();

      $respArr['is_driver'] = ($userData['is_driver'] == 1)?true:false;
      $respArr['is_registered_as_driver'] = ($userData['driver_enabled'] == 1)?true:false;
      $respArr['user']['user_id'] = $userData['id'];
      $respArr['user']['first_name'] = $userData['first_name'];
      $respArr['user']['sur_name'] = $userData['surname'];
      $respArr['user']['phone'] = $userData['phone'];
      $respArr['user']['email'] = $userData['email_id'];
      $respArr['user']['rating'] = $userData['appRate'];
      $respArr['user']['total_order'] = $userData['user_oder_count'];
      $respArr['user']['wallet'] = $userData['wallet'];
      $respArr['user']['notification'] = ($userData['notification'] == 1)?true:false;
      $respArr['user']['profile_photo'] = $userData['profile_image'];
      $respArr['driver'] = array();
      if($userData['driver_enabled']){
            $respArr['driver']['user_id'] = $userData['id'];
            $respArr['driver']['first_name'] = $userData['first_name'];
            $respArr['driver']['sur_name”'] = $userData['surname'];
            $respArr['driver']['phone'] = $userData['phone'];
            $respArr['driver']['email'] = $userData['email_id'];
            $respArr['driver']['rating'] = $userData['drvRate'];
            $respArr['driver']['total_order'] = $userData['driver_oder_count'];
            $respArr['driver']['wallet'] = $userData['wallet'];
            $respArr['driver']['earnings'] = $userData['earnings'];
            $respArr['driver']['notification'] = ($userData['notification'] == 1)?true:false;
            $respArr['driver']['profile_photo'] = $userData['profile_image'];
      }
      $result = array('status' => 'success', 'data' => $respArr);
}
else{
      $result = array("status" => "error","error" => "No data","message" => "No data");
}

return $result;

}

public function profile_edit_update($request){

      $query = $this->db->where('unique_id', $request['auth'])->get('auth_table');
      if($query->num_rows() > 0){
            $rs = $query->row();
            $user_id = $rs->member_id;

            $this->db->where('email_id',$request['email']);
            $this->db->where('id!=',$user_id);
            $res = $this->db->get('users');

            if($res->num_rows() == 0){

                  $data = array('first_name'=>$request['first_name'],
                        'surname' =>$request['sur_name'],
                        'email_id' =>$request['email'],
                        'profile_image'=>$request['profile_photo']);

                  $this->db->where('id', $user_id)->update('users', $data);

                  $result = array('status' => 'success');
            }else{

                  $result = array('status' => 'exists');
            }

      }else{
            $result = array('status' => 'error');
      }

      return $result;

}

public function add_home_work($request){



      $query = $this->db->where('unique_id',$request['auth'])->get('auth_table');

      if($query->num_rows()>0){

            $rs = $query->row();

            if($request['type']==0){

                  $data = array('users_id'=>$rs->member_id,'location'=>$request['home'],'lat'=>$request['home_latitude'],'lng'=>$request['home_longitude'],'type'=>$request['type'],'status'=>'1');

            }else{

                  $data = array('users_id'=>$rs->member_id,'location'=>$request['work'],'lat'=>$request['work_latitude'],'lng'=>$request['work_longitude'],'type'=>$request['type'],'status'=>'1');

            }

            $this->db->insert('user_address',$data);

            return true;

      }else{  
            return false;
      }

}

public function location_details($request){

      $query = $this->db->where('unique_id',$request['auth'])->get('auth_table');

      if($query->num_rows()>0){


            $rs = $query->row();

            $cust_id = $rs->member_id;

            $data = "SELECT type,location,lat,lng FROM user_address WHERE users_id='$cust_id' AND status='1'";

            

            $query = $this->db->query($data);

            $home = $work = array();
            
            $result = $query->result_array();
            if(empty($result)){
                  return array('status' => 'success', 'data' => array('home' => $home, 'work' => $work));
            }

            
            foreach($result AS $address){
                  if($address['type'] == '0'){
                        $home[] = array('name' => $address['location'],
                                        'latitude' =>$address['lat'],
                                        'longitude' =>$address['lng']); 
                  }else{
                        $work[] = array('name' => $address['location'],
                                        'latitude' =>$address['lat'],
                                        'longitude' =>$address['lng']); 
                  }
            }
            if($result){
                  $result = array('status' => 'success', 'data' => array('home' => $home, 'work' => $work));
            }else{
             $result = array('status' => 'error');
       }

       return $result;

 }else{
       return false;
 }
}

public function user_rating($request){

      $query = $this->db->where('unique_id',$request['auth'])->get('auth_table');
      if($query->num_rows()>0){

            $rs = $query->row();

            $cust_id = $rs->member_id;

            $data = array('rate'=>$request['rating'],
                          'orders_id'=>$request['order_id'],
                          'users_id'=>$request['user_id'],
                          'driver_id'=>$cust_id);

            $res = $this->db->insert('user_rate',$data);

            if($res){
                  $result = array('status' => 'success');
            }else{
             $result = array('status' => 'error');
       }
       return $result;

 }else{

      return false;
}

}

public function driver_rating($request){

      $query = $this->db->where('unique_id',$request['auth'])->get('auth_table');

      if($query->num_rows()>0){

            $rs = $query->row();

            $cust_id = $rs->member_id;

            $data = array('rate'=>$request['rating'],
                          'orders_id'=>$request['order_id'],
                          'driver_id'=>$request['driver_id'],
                          'users_id'=>$cust_id);

            $res = $this->db->insert('driver_rate',$data);

            if($res){
                  $result = array('status' => 'success');
            }else{
             $result = array('status' => 'error');
       }
       return $result;

 }else{

       return false;
 }

}

public function app_rating($request){


      $query = $this->db->where('unique_id',$request['auth'])->get('auth_table');

      if($query->num_rows()>0){

            $rs = $query->row();

            $cust_id = $rs->member_id;

            $data = array('rate'=>$request['rating'],
              'comments'=>$request['feedback'],
              'users_id'=>$cust_id);

            $res = $this->db->insert('app_rate',$data);

            if($res){
                  $result = array('status' => 'success');
            }else{
             $result = array('status' => 'error');
       }
       return $result;

 }else{

       return false;
 }

}

function get_last_order($user_data = array()){
      $result = array('status' => 'error');

      if(empty($user_data)){
            return $result;
      }
      $query = $this->db->where('unique_id',$user_data['auth'])->get('auth_table')->row();
      if(empty($query)){
            return $result;
      }
      $user_id = $query->member_id;
      $query = $this->db->query("SELECT ODR.* ,DR_RATE.id AS rateId, USR.first_name, 
                                 USR.surname,USR.profile_image
                                 FROM orders AS ODR 
                                 LEFT JOIN driver_rate AS DR_RATE ON (DR_RATE.orders_id = ODR.id)
                                 INNER JOIN users AS USR ON (USR.id = ODR.driver_id)
                                 WHERE ODR.status = '3' AND ODR.users_id = '".$user_id."' 
                                 ORDER BY ODR.id DESC LIMIT 1")->row_array();
      if(empty($query)){
            $result['message'] = 'No Data';
      }
      $orderData = array();
      $orderData['status'] = 'success';
      $orderData['data']['is_last_order_rated'] = (!empty($query['rateId']))?true:false;
      $orderData['data']['order_id'] = $query['id'];
      $orderData['data']['driver_id'] = $query['driver_id'];
      $orderData['data']['driver_name'] = $query['first_name'].' '.$query['surname'];
      $orderData['data']['amount'] = $query['amount'];
      $orderData['data']['date'] = strtotime($query['date'].' '.$query['time']);
      $orderData['data']['shop_name'] = $query['shop_name'];
      $orderData['data']['driver_photo'] = $query['profile_image'];
      $orderData['data']['item_name'] = $query['order_desc'];
      $orderData['data']['item_quantity'] = '';

      return $orderData;
}

function get_last_order_driver($user_data = array()){
      $result = array('status' => 'error');

      if(empty($user_data)){
            return $result;
      }
      $query = $this->db->where('unique_id',$user_data['auth'])->get('auth_table')->row();
      if(empty($query)){
            return $result;
      }
      $user_id = $query->member_id;
      $query = $this->db->query("SELECT ODR.* ,DR_RATE.id AS rateId, USR.first_name, 
                                 USR.surname,USR.profile_image
                                 FROM orders AS ODR 
                                 LEFT JOIN driver_rate AS DR_RATE ON (DR_RATE.orders_id = ODR.id)
                                 INNER JOIN users AS USR ON (USR.id = ODR.users_id)
                                 WHERE ODR.status = '3' AND ODR.driver_id = '".$user_id."' 
                                 ORDER BY ODR.id DESC LIMIT 1")->row_array();
      if(empty($query)){
            $result['message'] = 'No Data';
      }
      $orderData = array();
      $orderData['status'] = 'success';
      $orderData['data']['is_last_order_rated'] = (!empty($query['rateId']))?true:false;
      $orderData['data']['order_id'] = $query['id'];
      $orderData['data']['driver_id'] = $query['driver_id'];
      $orderData['data']['driver_name'] = $query['first_name'].' '.$query['surname'];
      $orderData['data']['amount'] = $query['amount'];
      $orderData['data']['date'] = strtotime($query['date'].' '.$query['time']);
      $orderData['data']['shop_name'] = $query['shop_name'];
      $orderData['data']['driver_photo'] = $query['profile_image'];
      $orderData['data']['item_name'] = $query['order_desc'];
      $orderData['data']['item_quantity'] = '';

      return $orderData;
}

public function request_cancel($request = array()){

      if(empty($request) || !isset($request['id'],$request['auth']) || empty($request['id']) || empty($request['auth'])){
            return array('status'=>'error','message'=>'No data');
      }
      $user_id = $this->getUserId($request['auth']);
      if(empty($user_id)){
            return array('status'=>'error');
      }
      $query1 = $this->db->where('id',$request['id'])->get('orders')->row();
      $request_id = $query1->req_id;
      $update_request_status = $this->db->update('request',array('status'=>'2'),array('id'=>$request_id));

      $query = $this->db->update('orders',array('status'=>'3'), array('id'=>$request['id']));
      // $query = $this->db->update('request',array('status'=>'2'), array('id'=>$request['id']));
      if ($query) {
            return array('status' => 'success','message' => 'Successfully Cancelled..!!');
      }
      return array('status'=>'error');
}

public function request_status($request = array()){

      if(empty($request) || !isset($request['id'],$request['auth']) || empty($request['id']) || empty($request['auth'])){
            return array('status'=>'error','message'=>'No data');
      }
      $user_id = $this->getUserId($request['auth']);
      if(empty($user_id)){
            return array('status'=>'error');
      }
      $query = $this->db->query("SELECT ODR.delivery_fee,ODR.id,REQ.status
                                 FROM request AS REQ
                                 LEFT JOIN orders AS ODR ON (ODR.req_id = REQ.id)
                                 WHERE REQ.id = '".$request['id']."'")->row_array();
      if (empty($query)) {
            return array('status' => 'error','message');
      }
      $status = $query['status'];
      switch($status){
            case 0:
                  return array("status"=>"success","data"=>array("request_status"=>"0"));
            case 1:
                  return array("status"=>"success",
                               "data"=>array("request_status"=>"1",
                                             "delivery_fee"=>$query['delivery_fee'],
                                             "order_id"=>$query['id']));
            case 2:
                  return array("status"=>"success","data"=>array("request_status"=>"2"));
      }
}

function tracking_details($request = array()){
      if(empty($request) || !isset($request['order_id'],$request['auth']) || empty($request['order_id']) || empty($request['auth'])){
            return array('status'=>'error','message'=>'No data');
      }
      $user_id = $this->getUserId($request['auth']);
      if(empty($user_id)){
            return array('status'=>'error');
      }

      $data = $this->db->query("SELECT ODR.*,ODR.delivery_lat AS lat,ODR.delivery_lng AS lng,
                                       DRV.profile_pic,USR.phone,DRV.driver_lat,DRV.driver_lng
                                FROM orders AS ODR
                                INNER JOIN users AS USR ON (USR.id = ODR.driver_id)
                                INNER JOIN drivers AS DRV ON (DRV.users_id = ODR.driver_id)
                                WHERE ODR.id='".$request['order_id']."' AND USR.status = '1' AND DRV.status = '1'")->row_array();
      if(!empty($data)){
            return array('status'=>'success','orderData'=>$data);
      }
      return array('status'=>'error');
}

function getUserId($auth = ''){
      if(empty($auth)){
            return;
      }
      $query = $this->db->where('unique_id',$auth)->get('auth_table')->row();
      if(empty($query)){
            return;
      }
      return $query->member_id;
}

function geySysSettings(){
      $data = $this->db->get('setting')->row();
      if(!empty($data)){
            return $data;
      }
      return 0;
}

function orders_list($request = array()){
      $data = $this->geySysSettings();
      $google_key = $data->google_api_key;

      if(empty($request) || !isset($request['auth']) || empty($request['auth'])){
            return array('status'=>'error','message'=>'No data');
      }
      $user_id = $this->getUserId($request['auth']);
      if(empty($user_id)){
            return array('status'=>'error');
      }

      $isDriver = $this->db->select('is_driver')->where(array('users_id'=>$user_id))->get('user_profile')->row_array();
      $isDriver = (!empty($isDriver) && isset($isDriver['is_driver']))?$isDriver['is_driver']:'0';

      $limit_offset = '10';
      $page_no = (isset($request['page_no']) && !empty($request['page_no']))?$request['page_no']:1;
      if($page_no != 1){
            $limit_offset = ($page_no-1).'0,10';
      }
      $count = '';
      $query = '';
      if($isDriver == '0'){
            $count = $this->db->get_where('orders',array('users_id'=>$user_id));
            $count = (!empty($count))?$count->num_rows():0;

            $query = $this->db->query("SELECT ODR.*,USR.first_name,USR.surname,USR.profile_image
                    FROM orders AS ODR
                    INNER JOIN users AS USR ON (USR.id = ODR.users_id)
                    WHERE ODR.users_id='".$user_id."' AND USR.status = '1' ORDER BY ODR.id DESC 
                    LIMIT ".$limit_offset)->result_array();
      } else {
            $count = $this->db->get_where('orders',array('driver_id'=>$user_id));
            $count = (!empty($count))?$count->num_rows():0;

            $query = $this->db->query("SELECT ODR.*,USR.first_name,USR.surname,DRV.profile_pic AS profile_image
                    FROM orders AS ODR
                    INNER JOIN users AS USR ON (USR.id = ODR.driver_id)
                    INNER JOIN drivers AS DRV ON (DRV.users_id = ODR.driver_id)
                    WHERE ODR.driver_id='".$user_id."' AND USR.status = '1' AND DRV.status = '1'
                    ORDER BY ODR.id DESC LIMIT ".$limit_offset)->result_array();
      }
      $orderData = array();
      foreach($query AS $order){
            $shopData = file_get_contents("https://maps.googleapis.com/maps/api/geocode/json?place_id=".$order['shop_id']."&key=".$google_key);
            if(empty($shopData)){
                  continue;
            }
            switch ($order['status']) {
              case '1':
                $order['status'] = '2';
                break;
              case '2':
                $order['status'] = '3';
                break;
              case '3':
                $order['status'] = '4';
                break;
            }

            $shopData = json_decode($shopData,true);

            $details['order_id'] = $order['id'];
            $details['type'] = $isDriver;
            $details['name'] = $order['first_name'].' '.$order['surname'];
            $details['amount'] = $order['price'];
            $details['delivery_mode'] = $order['delivery_mode'];
            $details['date'] = strtotime($order['date'].' '.$order['time']);
            $details['shop_name'] = $order['shop_name'];
            $details['address'] = $shopData['results'][0]['formatted_address'];
            $details['shop_subname'] = $order['shop_name'];
            $details['photo'] = $order['profile_image'];
            $details['order_status'] = $order['status'];
            $details['receipt_amount'] = $order['receipt_amount'];
            $details['total_amount'] = $order['amount'];
            $details['delivery_charge'] = $order['delivery_fee'];
            $details['item_name'] = $order['order_desc'];

            $orderData[] = $details;
      }
      $tot_page = ceil($count/10);
      return array('status'=>'success','data'=>array('orders_list'=>$orderData),'meta'=>array('total_pages'=>$tot_page,'total'=>$count,'current_page'=>$page_no,'per_page'=>'10'));
     
}

function issuing_receipt($request = array()){
      if(empty($request) || !isset($request['auth']) || empty($request['auth'])){
            return array('status'=>'error','message'=>'No data');
      }
      $user_id = $this->getUserId($request['auth']);
      if(empty($user_id)){
            return array('status'=>'error');
      }

      $status = $this->db->update('orders', array('price'=>$request['receipt_amount'],'amount'=>$request['total_amount'],'delivery_fee'=>$request['delivery_fee'],'receipt_photo'=>$request['receipt_photo'],), array('id'=>$request['order_id']));
      if($status){
            return array('status'=>'success');
      }
      return array('status'=>'error');
}

function request_order($request = array()){
      if(empty($request) || !isset($request['auth']) || empty($request['auth'])){
            return array('status'=>'error','message'=>'No data');
      }
      $user_id = $this->getUserId($request['auth']);
      if(empty($user_id)){
            return array('status'=>'error');
      }
      $status = $this->db->insert('request',array('users_id'=>$user_id,'delivery_location'=>$request['location_name'],'delivery_lat'=>$request['delivery_latitude'],'delivery_lng'=>$request['delivery_longitude'],'shop_id'=>$request['shop_id'],'shop_name'=>$request['shop_name'],'item_name'=>$request['item_name'],'date'=>date('Y-m-d'),'time'=>date('h:i:s'),'delivery_mode'=>$request['delivery_mode'],'status'=>'0'));

    $requested_id = $this->db->insert_id();



      $order = $this->db->insert('orders',array('users_id'=>$user_id,'req_id'=>$requested_id,'delivery_location'=>$request['location_name'],'delivery_lat'=>$request['delivery_latitude'],'delivery_lng'=>$request['delivery_longitude'],'shop_id'=>$request['shop_id'],'shop_name'=>$request['shop_name'],'item_name'=>$request['item_name'],'date'=>date('Y-m-d'),'time'=>date('h:i:s'),'delivery_mode'=>$request['delivery_mode'],'status'=>'0'));
      if($status){
            return array('status'=>'success');
      }
      return array('status'=>'error');
}

public function chat_file_upload($request){


  $query = $this->db->where('unique_id', $request['auth'])->get('auth_table');


      if ($query->num_rows() > 0) {

            $rs = $query->row();

            $id = $rs->member_id;

            $data = array('chat_list_id' => $request['chat_list_id'],
                      'chat_id' => $request['chat_id'],
                      'type' => $request['type'],
                      'file' => $request['doc']);
            $this->db->insert('chat_history',$data);

            $result = array('status' => 'success','data'=>array('chat_list_id'=>$request['chat_list_id'],'chat_id'=>$request['chat_id'],'file'=>$request['doc']));


      } else{

            $result = array('status' => 'error');
      }

      return $result;
}

function set_user_recent_chat($request = array()){
      if(empty($request) || !isset($request['auth']) || empty($request['auth'])){
            return array('status'=>'error','message'=>'No data');
      }
      $user_id = $this->getUserId($request['auth']);
      if(empty($user_id)){
            return array('status'=>'error');
      }
      $status = $this->db->insert('chat',array('chat_list_id'=>$request['chat_list_id'],'user_id'=>$request['user_id'],'driver_id'=>$request['driver_id'],'sender_id'=>$request['sender_id'],'type'=>$request['type'],'message'=>$request['message'],'photo_url'=>$request['photo_url'],'video_url'=>$request['video_url'],'order_id'=>$request['order_id'],'time'=>$request['time']));
      if($status){
            return array('status'=>'success');
      }
      return array('status'=>'error');
}

function request_trigger(){

      $data = $this->geySysSettings();
      $google_key = $data->google_api_key;

      $newTime = date("Y-m-d H:i:s",strtotime(date("Y-m-d H:i:s")." -1 minutes"));

      $sql = "SELECT REQ.id FROM request AS REQ 
              LEFT JOIN rider_state AS RS ON (RS.req_id = REQ.id AND RS.assigned_time <= '".$newTime."')
              WHERE REQ.status IN (0,2,3)";

      $data = $this->db->query($sql);
      if(empty($data)){
         return;
      }
      $data = $data->result_array();

      foreach($data as $id){
         $reqData = $this->db->query("SELECT REQ.shop_id,GROUP_CONCAT(RS.driver_id) AS driver_id,
                                             REQ.users_id
                                      FROM request AS REQ
                                      LEFT JOIN rider_state AS RS ON (RS.req_id = REQ.id)
                                      WHERE REQ.id = '".$id['id']."'")->row_array();

         if(empty($reqData) || empty($reqData['shop_id'])){
               continue;
         }
         $shopData = file_get_contents("https://maps.googleapis.com/maps/api/geocode/json?place_id=".$reqData['shop_id']."&key=".$google_key);
         if(empty($shopData)){
               continue;
         }
         $shopData = json_decode($shopData,true);
         $shopLoc = $shopData['results'][0]['geometry']['location'];
         $user_id = (!empty($reqData['users_id']))?$reqData['users_id']:'';
         $drvCond = (!empty($reqData['driver_id']))?' AND driver.users_id NOT IN ('.$reqData['driver_id'].','.$user_id.')':' AND driver.users_id NOT IN ('.$user_id.')';
            $lat = $shopLoc['lat'];
         $lng = $shopLoc['lng'];
         $rideData = $this->db->query("SELECT driver.users_id, 3956 * 2 * ASIN(SQRT(POWER(SIN(($lat - driver.driver_lat) * pi()/180 / 2), 2)+ COS($lat * pi()/180 ) * COS(driver.driver_lat * pi()/180)* POWER(SIN(($lng - driver.driver_lng) * pi()/180 / 2), 2) )) as distance, UP.fcm_token AS fcm_token
                           FROM drivers AS driver
                           LEFT JOIN user_profile AS UP ON (UP.users_id = driver.users_id)
                           WHERE driver.status = '1' AND UP.driver_enabled = '1' AND 
                                 UP.is_driver = '1'  $drvCond
                           GROUP BY driver.users_id HAVING distance < 25
                           ORDER BY distance ASC LIMIT 0,1")->row_array();

        if(empty($rideData) || !isset($rideData['users_id']) || empty($rideData['users_id'])){
               continue;
         }
         $this->db->insert('rider_state', array('driver_id'=>$rideData['users_id'],'req_id'=>$id['id'],
                                                'assigned_time'=>date('Y-m-d h:i:s')));

         $fcm_data = array('id'=>$id['id'],'title'=>'WAAW','message'=>'Delivery Request');
         $this->push_sent_cancel($rideData['fcm_token'], $fcm_data);
      }
      return;
}

function get_recent_chat_list($request = array()){
      if(empty($request) || !isset($request['auth']) || empty($request['auth'])){
            return array('status'=>'error','message'=>'No data');
      }
      $user_id = $this->getUserId($request['auth']);
      if(empty($user_id)){
            return array('status'=>'error');
      }
      $limit_offset = '10';
      $page_no = (isset($request['page']) && !empty($request['page']))?$request['page']:1;
      if($page_no != 1){
            $limit_offset = ($page_no-1).'0,10';
      }
      // $resultData = $this->db->query("
      //                            SELECT CH.*, ORD.status AS order_status FROM chat AS CH 
      //                            LEFT JOIN orders AS ORD ON (ORD.id = CH.order_id)
      //                            WHERE CH.user_id = '".$user_id."' LIMIT ".$limit_offset)->result_array();
      $resultData = $this->db->query("
                                 SELECT CH.*, ORD.status AS order_status FROM chat AS CH 
                                 INNER JOIN orders AS ORD ON (ORD.id = CH.order_id)
                                 WHERE ORD.status IN (1)
                                 LIMIT ".$limit_offset)->result_array();
      $chatData = array();
      $user_data = array();
      $chkUserData = 0;
      foreach($resultData AS $data){
            if($chkUserData == 0){
                  $user = $this->db->get_where('users',array('id'=>$data['user_id']))->row_array();
                  if(empty($user)){
                    continue;
                  }
                  $user_data['user_name'] = $user['first_name'].' '.$user['surname'];
                  $user_data['user_photo'] = $user['profile_image'];

                  $user = $this->db->query("SELECT DRV.profile_pic,USR.first_name,USR.surname
                                            FROM users AS USR
                                            INNER JOIN drivers AS DRV ON (DRV.users_id = USR.id)
                                            WHERE USR.id='".$data['driver_id']."'")->row_array();
                  
                  if(empty($user)){
                    continue;
                  }
                  $user_data['driver_name'] = $user['first_name'].' '.$user['surname'];
                  $user_data['driver_photo'] = $user['profile_pic'];
                  $chkUserData = 1;
            }
            $chatData['type']         = $data['type'];
            $chatData['time']         = $data['time'];
            $chatData['chat_id']      = $data['chat_id'];
            $chatData['user_id']      = $data['user_id'];
            $chatData['order_id']     = $data['order_id'];
            $chatData['driver_id']    = $data['driver_id'];
            $chatData['message']      = $data['message'];
            $chatData['photo_url']    = $data['photo_url'];
            $chatData['video_url']    = $data['video_url'];
            $chatData['sender_id']  = $data['sender_id'];
            $chatData['order_status']  = $data['order_status'];

            $chatData['user_name']    = $user_data['user_name'];
            $chatData['user_photo']   = $user_data['user_photo'];
            $chatData['driver_name']  = $user_data['driver_name'];
            $chatData['driver_photo'] = $user_data['driver_photo'];
      }
        return array("status"=>"success","data"=>array('recent_chats'=>array($chatData)));
}


   public function request_details($request){

    $data = $this->geySysSettings();
    $google_key = $data->google_api_key;
                             

      $rs2 = $this->db->query("SELECT REQ_TB.* ,USERS_TB.id AS userid, USERS_TB.profile_image                         AS user_photo,USERS_TB.first_name,USERS_TB.surname, USERS_TB.phone AS user_phone_number
                                 FROM request AS REQ_TB 
                                 JOIN users AS USERS_TB ON (USERS_TB.id = REQ_TB.users_id)
                                 WHERE REQ_TB.id = '".$request['request_id']."'")->row();

 


       if(!empty($rs2)){ 

            $shopData = file_get_contents("https://maps.googleapis.com/maps/api/geocode/json?place_id=".$rs2->shop_id."&key=".$google_key);
            if(empty($shopData)){
            return array('status'=>'error');
            }
            $shopData = json_decode($shopData,true);
            // print_r($shopData);
            // die();
            $shopLoc = $shopData['results'][0]['geometry']['location'];
         
            $shopAddress = $shopData['results'][0]['formatted_address'];
           
$milliseconds = round(microtime(true) * 1000);
 

            $data = array('request_id' => $rs2->id,
                  'shop_name' =>$rs2->shop_name,
                  'shop_address'=>$shopAddress,
                  'user_phone_number' =>$rs2->user_phone_number,
                  'user_photo' => $rs2->user_photo, 
                  'shop_latitude' =>$shopLoc['lat'],
                  'shop_longitude' =>$lng = $shopLoc['lng'],
                  'delivery_latitude'=>$rs2->delivery_lat,
                  'delivery_longitude'=>$rs2->delivery_lng,
                  'request_time' => $milliseconds,
                 'user_id' => $rs2->users_id,
                'user_name' => $rs2->first_name.' '.$rs2->surname);

           
      
            $result = array('status' => 'success','user' => $data);


      }
      else{
            $result = array('status' => 'error');
         }
     
      return $result;

   }
   public function order_status($request){

      $data = $this->geySysSettings();
      $google_key = $data->google_api_key;

      $rs = $this->db->query("SELECT * FROM orders
                                 WHERE id = '".$request['order_id']."'")->row();

     
      if(!empty($rs)){ 

            $shopData = file_get_contents("https://maps.googleapis.com/maps/api/geocode/json?place_id=".$rs->shop_id."&key=".$google_key);
            if(empty($shopData)){
            return array('status'=>'error');
            }
            $shopData = json_decode($shopData,true);
            $shopAddress = $shopData['results'][0]['formatted_address'];

            $data = array('order_status' => $rs->status,
               'item_name' => $rs->item_name,
               'amount' => $rs->amount,
               'address'=>$shopAddress,
                  
               );

            $result = array('status' => 'success','user' => $data);


      }
      else{
            $result = array('status' => 'error');
         }
     
      return $result;




   }

   public function confirm_delivery($request){

       
      $query = $this->db->where('unique_id', $request['auth'])->get('auth_table');
      if ($query->num_rows() > 0) {

            $rs = $query->row();

            $id = $rs->member_id;

            $rs = $this->db->query("SELECT receipt_photo FROM orders
                                 WHERE id = '".$request['order_id']."'")->row();
      
            if($rs->receipt_photo != ''){ 

            $data = array('status' => '2');

            $this->db->where('users_id', $id);

            $this->db->where('id', $request['order_id']);

            $query = $this->db->update('orders', $data);

            $result = array('status' => 'success');
            return $result;
         }
         else{

             $result = array('status' => 'error','message' => 'Please upload the receipt_photo');
            return $result;

         }

      } else {

            $result = array('status' => 'error','message' => 'Insufficient data');
            return $result;

      }
   }

   public function order_accept_reject($request){

      $order_status = $request['type'];
       $order_id = $request['request_id'];

      $query = $this->db->where('unique_id', $request['auth'])->get('auth_table');
      if ($query->num_rows() > 0) {

            $rs = $query->row();

            $id = $rs->member_id;

          $data1 = "SELECT id FROM orders WHERE req_id = $order_id";
          $query1 = $this->db->query($data1);
          $rs = $query1->row();
          $ord_id = $rs->id;
            if($order_status==0)
            {
               $data = array('status' => '1');
               $data1 = array('driver_id' => $id,
                              'status' => '1'
                        );
               $this->db->where('id', $request['request_id']);
               $query = $this->db->update('request', $data);
               // echo $this->db->last_query();
               // die();
               $this->db->where('req_id', $request['request_id']);
               $query = $this->db->update('orders', $data1);
              $result = array('status' => 'success','data'=> $ord_id);
               $fcm_data = array('id'=>$order_id,'title'=>'WAAW','message'=>'Request Accepted');

               $this->push_sent_cancel($rideData['fcm_token'], $fcm_data);
               return $result;

            }

            if($order_status==1)
            {
               $data = array('status' => '2');
               $this->db->where('id', $request['request_id']);
               $query = $this->db->update('request', $data);
               $result = array('status' => 'success','data'=> $ord_id);
               $fcm_data = array('id'=>$order_id,'title'=>'WAAW','message'=>'Request Rejected');

               $this->push_sent_cancel($rideData['fcm_token'], $fcm_data);
               return $result;
            }

      } else {

            $result = array('status' => 'error');
            return $result;

      }


   }

   function push_sent_cancel($fcm_token, $fcm_data) {

          $data1 = "SELECT * FROM setting WHERE id = '1' ";

          $query1 = $this->db->query($data1);

          $rs = $query1->row();
          $key = $rs->api_key;

            $data = "{ \"notification\": { \"title\": \"".$fcm_data['title']."\", \"text\": \"".$fcm_data['message']."\", \"sound\": \"default\" }, \"time_to_live\": 60, \"data\" : {\"response\" : {\"status\" : \"success\", \"data\" : {\"request_id\" : \"".$fcm_data['id']."\", \"trip_status\" : 0}}}, \"collapse_key\" : \"trip\", \"priority\":\"high\", \"to\" : \"".$fcm_token."\"}";
           


            $ch = curl_init("https://fcm.googleapis.com/fcm/send");

            $header = array('Content-Type: application/json', 'Authorization: key='.$key);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $header);

            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

            curl_setopt($ch, CURLOPT_POST, 1);

            curl_setopt($ch, CURLOPT_POSTFIELDS, $data);

            // curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

            // curl_close($ch);

            $out = curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            
            curl_exec($ch);
            curl_close($ch);

      }

   public function search($request){

      $data = $this->geySysSettings();
      $google_key = $data->google_api_key;
      if(!isset($request['type']) || empty($request['type']) || !isset($request['latitude']) || empty($request['latitude']) || !isset($request['longitude']) || empty($request['longitude'])){
         return array('status'=>'error');
      }
      if(isset($request['page_token']) && !empty($request['page_token'])){
         $urlParams = '&pagetoken='.$request['page_token'];
      } else {
         $urlParams = "&location=".$request['latitude'].",".$request['longitude'];
         $urlParams.= "&rankby=distance";
         $urlParams.= "&type=".str_replace(',','|',trim($request['type']));
         if(isset($request['query']) && !empty($request['query'])){
            $urlParams.= "&keyword=".str_replace(',','|',trim($request['query']));
         }
      }

      $searchData = file_get_contents("https://maps.googleapis.com/maps/api/place/nearbysearch/json?key=".$google_key.$urlParams);

      if(empty($searchData)){
         return array('status'=>'error');
      }
      $searchData = json_decode($searchData,true); 

      if(empty($searchData) || $searchData['status']!='OK'){
         return array('status'=>'error');
      }
      
      $deStores = array();
      $resultData = $this->db->query("SELECT place_id FROM delisted_stores WHERE status = '1'");
      if(!empty($resultData)){
         $resultData = $resultData->result_array();
         foreach ($resultData AS $place_id) {
            $deStores[] = $place_id['place_id'];
         }
      }

      $i = 0;
      $placelist = array();

      $page_token = $searchData['next_page_token'];
      $searchData = $searchData['results'];
      foreach ($searchData AS $shopinfo) {
         
         if(!isset($shopinfo['place_id']) || empty($shopinfo['place_id']) || (!empty($deStores) && in_array($shopinfo['place_id'],$deStores))){
            continue;
         }
         $shopLoc = $shopinfo['geometry']['location'];
         $lat = $shopLoc['lat'];
         $lng = $shopLoc['lng'];

         $shopLoc = $shopinfo['geometry']['location'];

         if( isset($shopinfo['opening_hour']) || isset($shopinfo['opening_hour']['open_now'])||($shopinfo['opening_hours']['open_now'] == 1) && isset($shopinfo['opening_hours']['open_now']))
            $open_hotel = "true"; 
         else
             $open_hotel = "false"; 
         
          $placelist[$i]['place_id'] = (isset($shopinfo['place_id']))?$shopinfo['place_id']:"null";
          $placelist[$i]['name'] = (isset($shopinfo['name']))?$shopinfo['name']:"null";
          $placelist[$i]['image'] = (isset($shopinfo['icon']))?$shopinfo['icon']:"null";
          $placelist[$i]['rating'] =  (isset($shopinfo['rating']))?$shopinfo['rating']:"null";
          $placelist[$i]['latitude'] = (isset($lat))?$lat:"null";
          $placelist[$i]['longitude'] =  (isset($lng))?$lng:"null";
          $placelist[$i]['is_opened'] =  (isset($open_hotel))?$open_hotel:"null";
          $placelist[$i]['address'] =  (isset($shopinfo['vicinity']))?$shopinfo['vicinity']:"null";

           $i++;

      }                          

      $result = array('status' => 'success','data' =>array('places_list' => $placelist),'meta'=>array('page_token'=>$page_token));
      return $result;
         
         
}

   public function order_picked_up($request){
 
      $query = $this->db->where('unique_id', $request['auth'])->get('auth_table');
      if ($query->num_rows() > 0) {

            $rs = $query->row();

            $id = $rs->member_id;

            $data = array('status' => '1');

            $this->db->where('users_id', $id);

            $this->db->where('id', $request['order_id']);

            $query = $this->db->update('orders', $data);

            $result = array('status' => 'success');
            return $result;
        

      } else {

            $result = array('status' => 'error');
            return $result;

      }
   }



}

?>
