<div class="content-wrapper">
  <section class="content-header">
    <h1><?= $pTitle ?><small><?= $pDescription ?></small></h1>
    <ol class="breadcrumb">
     <li><a href="<?= base_url() ?>"><i class="fa fa-star-o" aria-hidden="true"></i>Home</a></li>
     <li><?= $menu ?></li>
     <li class="active"><?= $smenu ?></li>
    </ol>
  </section>
  <section class="content">
    <div class="row">
      <div class="col-md-12">
        <?php 
        $url = (!isset($shop_id) || empty($shop_id))?'Shop/createShop':'Shop/updateShop/'.$shop_id;
        if($this->session->flashdata('message')) { 
          $flashdata = $this->session->flashdata('message'); ?>
          <div class="alert alert-<?= $flashdata['class'] ?>">
            <button class="close" data-dismiss="alert" type="button">×</button>
            <?= $flashdata['message'] ?>
          </div>
        <?php } ?>
      </div>
      <div class="col-md-12">
        <div class="box box-warning">
          <div class="box-body">
            <form role="form" action="<?= base_url($url) ?>" method="post" 
              class="validate" data-parsley-validate="" enctype="multipart/form-data">
              <div class="col-md-6">
                <div class="form-group">
                  <label>Shop Name</label>
                  <input type="text" class="form-control required" data-parsley-trigger="change"
                  data-parsley-minlength="2" data-parsley-pattern="^[a-zA-Z0-9\ . _ - ' \/]+$" 
                  name="shop_name" required="" value="<?= (isset($shop_data->shop_name))?$shop_data->shop_name:'' ?>"placeholder="Enter First Name">
                  <span class="glyphicon form-control-feedback"></span>
                </div>
                <div class="form-group">
                  <label>Email</label>
                  <input type="email" class="form-control required" data-parsley-trigger="change"  
                  data-parsley-minlength="2" required="" name="email_id" placeholder="Enter email ID"  value="<?= (isset($shop_data->email_id))?$shop_data->email_id:'' ?>">
                  <span class="glyphicon form-control-feedback"></span>
                </div> 
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label>Phone</label>
                  <input type="text" class="form-control required" data-parsley-trigger="change" 
                  data-parsley-minlength="2"  data-parsley-pattern="^[0-9\ , - + \/]+$" required=""
                  value="<?= (isset($shop_data->phone))?$shop_data->phone:'' ?>" name="phone" placeholder="Enter Phone Number" >
                  <span class="glyphicon  form-control-feedback"></span>
                </div>
                <div class="form-group">
                  <label>Address</label>
                  <textarea type="text" class="form-control required" data-parsley-trigger="change" 
                  data-parsley-pattern="^[a-zA-Z0-9\ , # - . _ @  \/]+$" required="" 
                  data-parsley-minlength="2" name="address" placeholder="Enter Address"><?= (isset($shop_data->address))?$shop_data->address:'' ?></textarea>
                  <span class="glyphicon form-control-feedback"></span>
                </div>
              </div>
              <div class="col-md-12">      
                <div class="box-footer textCenterAlign">
                  <button type="submit" class="btn btn-primary">Submit</button>
                  <a href="<?= base_url('Shop/viewShops') ?>" class="btn btn-primary">Cancel</a>
                </div>        
              </div>        
            </form>
          </div>
        </div>
      </div>
    </div>
  </section>
</div>