import { Component, OnInit } from '@angular/core';
import { Router, ActivatedRoute } from '@angular/router';
import { FormGroup, FormControl, Validators, ValidationErrors } from '@angular/forms';
import { ValidationService } from './../../provider/validation.service';
import { WebService } from './../../provider/web.service';
import { SubjectService } from './../../provider/subject.service';
import { ImageStorage } from '../../../environments/server.config';

@Component({
  selector: 'app-dashboard',
  templateUrl: './dashboard.component.html',
  styleUrls: ['./dashboard.component.scss']
})
export class DashboardComponent implements OnInit {

  tab: any;
  loader: boolean;
  editProfile;
  user_name: string;
  loginDetails: any;
  loginResponse: any;
  editProfileSubmitClick: boolean;

  constructor(private router        : Router, 
              private route         : ActivatedRoute,
              public errorMsg       : ValidationService,
              public webService     : WebService,
              public subjectService : SubjectService) {
    this.loader                     = false;
    this.editProfileSubmitClick     = false;            
  }

  ngOnInit() {
    this.loginResponse.status = "success";
    this.loginResponse.message = "message";
    this.tab = 'active';

    this.subjectService.getLoginData().subscribe(loginData => {
      this.loginDetails = JSON.parse(this.webService.getLocalStorageItem('userData'));

      if(this.loginDetails){
        console.log(this.loginDetails);
        this.editProfile = new FormGroup({
          email: new FormControl(this.loginDetails.email, [Validators.required, Validators.maxLength(50), Validators.pattern('^[a-z0-9._%+-]+@[a-z0-9.-]+\.[a-z]{2,4}$')]),
          phone: new FormControl(this.loginDetails.phone, [Validators.required, Validators.maxLength(15), Validators.pattern("^[0-9\ ( ) + , - ]+$")]),
          address: new FormControl(this.loginDetails.address, [Validators.required, Validators.maxLength(250)]),
          password: new FormControl('', [Validators.maxLength(16), Validators.minLength(6)]),
          cpassword: new FormControl('', [Validators.maxLength(16), Validators.minLength(6)]),
          last_name: new FormControl(this.loginDetails.last_name, [Validators.required, Validators.maxLength(50), Validators.pattern("^[a-zA-Z\ _ - ' \/]+$")]),
          first_name: new FormControl(this.loginDetails.first_name, [Validators.required, Validators.maxLength(50), Validators.pattern("^[a-zA-Z\ _ - ' \/]+$")])
        });
      } else {
        this.router.navigate(['index']);
      }
    });
  }

  submitProfileEdit(data){
    if(this.editProfile.invalid){
      return false;
    }
    const This = this;
    this.loader = true;
    let funcName = 'edit_customer_profile';
    this.webService.post_data(funcName, data).subscribe(response => {
      this.loader = false;
      if ( response.status == '1') {
        this.webService.setLocalStorageItem('userData', JSON.stringify(response.data));
        this.subjectService.sendLoginData('logged_in');

        this.editProfile.nativeElement.click();
      } else {
        response.status = 'error';
        response.message = (response.message == '')?this.errorMsg.errorList.req_failure:response.message; 

        this.editProfile = response;
      }
    },error => {
      this.editProfile = {'status':'error','message':this.errorMsg.errorList.req_failure};
    },() => {
      // setTimeout( function() {
      //   This.loginResponse = false;
      // }, 2000)
    });
  }

  routeToIndex(){
    this.router.navigate(["index"]);
  }

  tab_swap(type) { this.tab = type; }
}