import { Component, OnInit, NgZone, ViewChild, ElementRef } from '@angular/core';
import { Router,ActivatedRoute } from '@angular/router';
import { WebService } from '../../provider/web.service';
import { NgxCarousel } from 'ngx-carousel';
import { MapsAPILoader } from '@agm/core';
import { SubjectService } from '../../provider/subject.service';
import { FormGroup, FormControl, Validators, ValidationErrors } from '@angular/forms';
import { google } from '@google/maps';
import { ImageStorage } from '../../../environments/server.config';
import { formatDate } from '@angular/common';

declare var $;
declare const google: any;

@Component({
  selector: 'app-index',
  templateUrl: './index.component.html',
  styleUrls: ['./index.component.scss']
})

export class IndexComponent implements OnInit {
  public featuredOn: NgxCarousel;
  public carouselTile: NgxCarousel;

  @ViewChild('wizardModal') wizardModalTrrigerInput;

  //Default Map Location
  lat: number = 51.678418;
  lng: number = 7.809007;

  wizardData: any;
  loginDetails: any;

  //Basic Location Search: TAB 1
  autocomplete: any;
  searchLocError: boolean;
  @ViewChild("goTostep1") public goTostep1Ref: ElementRef;
  @ViewChild("closeWizard") public closeWizardRef: ElementRef;
  @ViewChild("step2nextBtn") public step2nextRef: ElementRef;
  @ViewChild("step3nextBtn") public step3nextRef: ElementRef;
  @ViewChild("googleLocSearch") public searchElementRef: ElementRef;
  @ViewChild("indexLoginModal") loginModalRef: ElementRef;
  @ViewChild("closeQuoteWizard") closeQuoteWizardRef: ElementRef;

  //Vehicle Details: TAB 2
  vehicleDataForm;
  vehicleDataFormSubmit;

  //Service Details: TAB 3
  loader: boolean;
  issuesData: any;
  selectedIssues: any[] = new Array();

  //Quote Page
  today: any = new Date();
  currDate: any;
  nextDate: any;
  dateStep: number = 0;
  dateSection: any[] = new Array();
  imageServer: string;
  mechanicData: any;
  autoSchedule: boolean;
  scheduleDateInit: boolean;

  carModel: any;
  modelDates: number[] = new Array();
  carSearchJsonData: any;

  constructor(
    private router        : Router, 
    public ngZone         : NgZone,
    public webService     : WebService,
    public mapsAPILoader  : MapsAPILoader,
    public subjectService : SubjectService) { 
      this.autoSchedule     = false;
      this.imageServer      = ImageStorage;
      this.currDate         = new Date();
      this.nextDate         = new Date();
      this.loginDetails     = false;
      this.searchLocError   = false;
      this.scheduleDateInit = false;
      this.vehicleDataFormSubmit = false;
    }

  ngOnInit() {
    this.vehicleDataForm = new FormGroup({
      trim: new FormControl(''), milage: new FormControl(''), emgine: new FormControl(''),
      maker: new FormControl('', [Validators.required]), 
      modelYear: new FormControl('', [Validators.required]), 
      modelName: new FormControl('', [Validators.required])
    });

    this.webService.get_stored_json('car-list.json').subscribe((response: any) => {     
      this.carSearchJsonData = response;
    });
    
    let currentYear = Number((new Date()).getFullYear());
    let startingYear = currentYear - 50;
    for (let date = currentYear ; date >= startingYear ; date --) {
      this.modelDates.push(date);
    }

    this.subjectService.getLoginData().subscribe(loginData => {
      this.loginDetails = JSON.parse(this.webService.getLocalStorageItem('userData'));

      if(this.loginDetails && this.autoSchedule){
        this.confirmBooking();
      }
    });

    this.mapsAPILoader.load().then(() => {
      this.autocomplete = new google.maps.places.Autocomplete(this.searchElementRef.nativeElement, {
        types: ["address"]
      });
    });
    
    this.featuredOn = {grid: {xs: 1, sm: 2 , md: 5, lg: 6, all: 0},slide: 1, speed: 400, animation: 'lazy',point: { visible: false },load: 2, touch: true, easing: 'ease'}
    this.carouselTile = {grid: {xs: 1, sm: 2 , md: 3, lg: 3, all: 0},slide: 1, speed: 400, animation: 'lazy',point: { visible: false },load: 2, touch: true, easing: 'ease'}
    this.nextDate.setDate(this.nextDate.getDate() + 1);
  }

  get_model(event) {
    this.carModel = this.carSearchJsonData[event].models;
  }

  setIssueSelected(event){
    let issue_id = event.target.attributes.issue_id.value;
    let sub_issue_id = event.target.attributes.sub_issue_id.value;

    let index = this.selectedIssues.findIndex(x => x.sub_issue_id == sub_issue_id);
    if(index > -1){
      this.selectedIssues.splice(index, 1);
    } else {
      const thisObj = this;
      this.issuesData.forEach(function (issData) {
        if(issData.issue_id == issue_id){
          issData.sub_categories.forEach(function (subIssData) {
            if(subIssData.issue_cat_id == sub_issue_id){
              let issue = issData.issue, 
                  issue_image = issData.issue_image,
                  issue_category = subIssData.issue_category,
                  issue_cat_image = subIssData.issue_cat_image,
                  default_service_fee = subIssData.default_service_fee,
                  default_description = subIssData.default_description;

              thisObj.selectedIssues.push({issue_id,sub_issue_id,issue,issue_image,issue_category,issue_cat_image,default_service_fee,default_description});
            }
          });
        }
      }); 
    }
  }

  removeSelectedItem(issue_id,sub_issue_id){
    let index = this.selectedIssues.findIndex(x => x.sub_issue_id == sub_issue_id);
    if(index > -1){
      this.selectedIssues.splice(index, 1);

      $('[id="issue_'+issue_id+'_'+sub_issue_id+'"]').prop('checked', false);
    }
    if(this.selectedIssues.length == 0){
      this.goTostep1Ref.nativeElement.click();
    }
  }

  getVehicleLoc(lastLoc){
    if(lastLoc == ''){
      this.searchLocError = true;
      return;
    }
    this.ngZone.run(() => {
      let place: google.maps.places.PlaceResult = this.autocomplete.getPlace();
      if (place == undefined || place == null || place === undefined || place === null || 
          place.geometry == undefined || place.geometry == null || place.geometry === undefined || place.geometry === null || 
          place.formatted_address == undefined || place.formatted_address == null || place.formatted_address === undefined || place.formatted_address === null) {
          this.searchLocError = true;
        return;
      }

      this.wizardData = {'pickup_data': 
                          {'pickup_loc':place.formatted_address,
                           'pickup_lat':place.geometry.location.lat(),
                           'pickup_lng':place.geometry.location.lng()
                          }
                        };

      this.searchLocError = false;
      this.lat = place.geometry.location.lat();
      this.lng = place.geometry.location.lng();
      this.wizardModalTrrigerInput.nativeElement.click();
    });
  }

  getVehicleData(vehicleData){
    if(this.vehicleDataForm.invalid){
      this.vehicleDataFormSubmit = true;
      return false;
    }
    this.wizardData['vechile_info'] = {'trim':vehicleData['trim'],'maker':this.carSearchJsonData[vehicleData['maker']]['brand'],
                                       'milage':vehicleData['milage'],'emgine':vehicleData['emgine'],
                                       'modelName':vehicleData['modelName'],'modelYear':vehicleData['modelYear']
                                      }
    this.getIssueData();
    this.vehicleDataFormSubmit = false;
    this.step2nextRef.nativeElement.click();
  }

  getIssueData(){
    const This = this;
    this.loader = true;
    this.webService.get_data('getGeneralIssues').subscribe(response => {
      this.loader = false;
      if(response.status == '1'){
        this.issuesData = response.issue_data;
      } else {
        return false;
      }
    },error => {
      return false;
    });
  }

  resetWizard(){
    this.vehicleDataForm.reset();
    this.searchElementRef.nativeElement.value = '';
  }

  jumpToStep3(){
    if(this.selectedIssues.length != 0){
      this.step3nextRef.nativeElement.click();
    }
  }

  getQuote(){
    const This = this;
    this.loader = true;

    this.webService.post_data('getNearByMechanics',this.wizardData.pickup_data).subscribe(response => {
      this.loader = false;
      if(response.status == '1'){
        this.mechanicData = response.mechanic_data;
        
        this.dateSection.push(new Date(this.today.setDate(this.today.getDate())));
        this.dateSection.push(new Date(this.today.setDate(this.today.getDate() + 1)));
       
      } else {
        return false;
      }
    },error => {
      return false;
    });
  }

  onMouseOver(infoWindow, gm) {
    if (gm.lastOpen != null) {
        gm.lastOpen.close();
    }
    gm.lastOpen = infoWindow;
    infoWindow.open();
  }

  onMouseOut(gm){
    if (gm.lastOpen != null) {
      gm.lastOpen.close();
    }
  }

  next(event) {
    if(this.dateStep > 30){
      return false;
    }
    this.dateSection = new Array();

    this.nextDate.setDate(this.nextDate.getDate() + 1);
    this.currDate.setDate(this.currDate.getDate() + 1);

    this.dateSection[0] = new Date(this.currDate);
    this.dateSection[1] = new Date(this.nextDate);

    this.dateStep += 1;
  }

  prev(event) {
    if(this.dateStep <= 0){
      return false;
    }
    this.dateSection = new Array();

    this.nextDate.setDate(this.nextDate.getDate() - 1);
    this.currDate.setDate(this.currDate.getDate() - 1);

    this.dateSection[0] = new Date(this.currDate);
    this.dateSection[1] = new Date(this.nextDate);

    this.dateStep -= 1;
  }

  getSchedule(time,index){
    this.scheduleDateInit = true;
    this.wizardData['schedule_date'] = {'date':this.formatDate(this.dateSection[index]),'time':time};
  }

  formatDate(date) {
    const d = new Date(date);
    let day = '' + d.getDate();
    let month = ''+(d.getMonth()+1);
    const year = d.getFullYear();
    if (day.length < 2) { day = '0'+day; }
    if (month.length < 2) { month = '0'+month; }
    return [year,month,day].join('-');
  }

  scheduleNow(mechanic_id){
    this.wizardData['mechanic_id'] = mechanic_id;

    if(!this.loginDetails){
      this.autoSchedule = true;
      this.loginModalRef.nativeElement.click();
      return false;
    }
    this.loader = true;
    this.confirmBooking();
  }

  confirmBooking(){
    this.wizardData['customer_id'] = this.loginDetails.customer_id;

    this.webService.post_data('scheduleNow',this.wizardData).subscribe(response => {
      this.loader = false;
      if(response.status == '1'){
        this.closeWizardRef.nativeElement.click();
        this.closeQuoteWizardRef.nativeElement.click();
        this.router.navigate(['../dashboard']);
      } else {
        return false;
      }
    },error => {
      this.loader = false;
      return false;
    });
  }

  featuredOnLoad() {return ''; }
  carouselTileLoad(){ return ''; }
}
