import { Injectable } from '@angular/core';
import { HttpClient, HttpHeaders, HttpErrorResponse } from '@angular/common/http';
import { Observable } from 'rxjs';
import { map, catchError } from 'rxjs/operators';
import { apiConfig, serverApiDev } from '../../environments/server.config';

const httpOptions = {
  headers: new HttpHeaders({
    'Content-Type': 'application/json',
    'Auth': 'my_key'
  })
};

const httplive = {
  headers: new HttpHeaders({
    'Access-Control-Allow-Origin': '*'
  })
};

@Injectable({
  providedIn: 'root'
})

export class WebService {
  constructor(private http: HttpClient) {}

  post_data(url: string, data) {
    return this.http.post(`${apiConfig + url}`, data, httpOptions).pipe(map((response: any) => response));
  }
  get_data(url) {
    return this.http.get(`${apiConfig + url}`, httpOptions).pipe(map((response: any) => response));
  }
  setLocalStorageItem(id: string, data: string) {
    localStorage.setItem(id, data);
  }
  getLocalStorageItem(data: string): string {
    return localStorage.getItem(data);
  }
  removeLocalStorageItem(data) {
    localStorage.removeItem(data);
    localStorage.clear();
  }
  online_service(url: string ) {
    return this.http.post(`${serverApiDev + url}`, null).pipe(map((response: any) => response));
  }
  get_stored_json(json_file: string) {
    return this.http.get("assets/json_data/" + json_file);
  }
}