<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Broker extends CI_Controller {

	public function __construct() {
		parent::__construct();
		date_default_timezone_set("Asia/Kolkata");
		$this->load->model('Broker_model');
		
		if(!$this->session->userdata('logged_in')) {
			redirect(base_url('Login'));
		}
 	}
 	
	public function add_broker() {
		$template['page'] = 'Broker/add_broker';

		$template['menu'] = "Broker Management";
		$template['sub_menu'] = "Add Broker";

        $template['page_desc'] = "Add New Broker";
        $template['page_title'] = "Add Broker";

		$this->load->view('template',$template);
	}

	public function view_brokers() {
		$template['page'] = 'Broker/view_brokers';

		$template['menu'] = "Broker Management";
		$template['sub_menu'] = "List Brokers";

        $template['page_desc'] = "Brokers List View";
        $template['page_title'] = "View Brokers";
        
        $template['brokers_data'] = $this->Broker_model->getBroker();

		$this->load->view('template',$template);
	}

	public function addBroker(){
		$err = 0;
		$errMsg = '';
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'error');
		if(!isset($_POST) || empty($_POST)){
			$this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Broker/add_broker'));
		}
		if($err == 0 && (!isset($_POST['broker_name']) || empty($_POST['broker_name']))){
			$err = 1;
			$errMsg = 'Provide a Broker Name';
		}else if($err == 0 && (!isset($_POST['broker_email']) || empty($_POST['broker_email']))){
			$err = 1;
			$errMsg = 'Provide an Email ID';
		}else if($err == 0 && (!isset($_POST['broker_phone']) || empty($_POST['broker_phone']))){
			$err = 1;
			$errMsg = 'Provide a Phone Number';
		}
		if($err == 1){
			$flashMsg['message'] = $errMsg;
			$this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Broker/add_broker'));
		}
		$status = $this->Broker_model->addBroker($_POST);
		if($status == 1){
			$flashMsg['class'] = 'success';
			$flashMsg['message'] = 'Broker Created';
		}else if($status == 2){
			$flashMsg['message'] = 'Email ID already in use.';
		}else if($status == 3){
			$flashMsg['message'] = 'Phone Number already in use.';
		}
		$this->session->set_flashdata('message',$flashMsg);
        redirect(base_url('Broker/add_broker'));
	}
	
	function changeStatus($broker_id = '',$status = '1'){
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'error');
		if(empty($broker_id)){
			$this->session->set_flashdata('message',$flashMsg);
        	redirect(base_url('Broker/view_brokers'));
		}
		$broker_id = decode_param($broker_id);
		$status = $this->Broker_model->changeStatus($broker_id,$status);
		if(!$status){
			$this->session->set_flashdata('message',$flashMsg);
		}
		redirect(base_url('Broker/view_brokers'));
	}

	function edit($broker_id = ''){
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'error');
		if(empty($broker_id)){
			$this->session->set_flashdata('message',$flashMsg);
        	redirect(base_url('Broker/view_brokers'));
		}
		$broker_id = decode_param($broker_id);

		$template['page'] = 'Broker/edit';

		$template['menu'] = "Broker Management";
		$template['sub_menu'] = "Edit Broker";

        $template['page_desc'] = "Edit Broker Details";
        $template['page_title'] = "Edit Broker";
        $template['broker_id'] = $broker_id;
        $template['broker_data'] = $this->Broker_model->getBroker($broker_id);

		$this->load->view('template',$template);
	}

	function update($broker_id = ''){
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'error');
		if(empty($broker_id)){
			$this->session->set_flashdata('message',$flashMsg);
        	redirect(base_url('Broker/view_brokers'));
		}
		$broker_id = decode_param($broker_id);

		$err = 0;
		$errMsg = '';
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'error');
		if(!isset($_POST) || empty($_POST)){
			$this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Broker/edit/'.encode_param($broker_id)));
		}
		if($err == 0 && (!isset($_POST['broker_name']) || empty($_POST['broker_name']))){
			$err = 1;
			$errMsg = 'Provide a Broker Name';
		}else if($err == 0 && (!isset($_POST['broker_email']) || empty($_POST['broker_email']))){
			$err = 1;
			$errMsg = 'Provide an Email ID';
		}else if($err == 0 && (!isset($_POST['broker_phone']) || empty($_POST['broker_phone']))){
			$err = 1;
			$errMsg = 'Provide a Phone Number';
		}
		if($err == 1){
			$flashMsg['message'] = $errMsg;
			$this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Broker/edit/'.encode_param($broker_id)));
		}

		$status = $this->Broker_model->updateBroker($broker_id,$_POST);
		if($status == 1){
			$flashMsg['class'] = 'success';
			$flashMsg['message'] = 'Broker Details Updated';
			$this->session->set_flashdata('message',$flashMsg);
			redirect(base_url('Broker/view_brokers'));
		}else if($status == 2){
			$flashMsg['message'] = 'Email ID already in use.';
		}else if($status == 3){
			$flashMsg['message'] = 'Phone Number already in use.';
		}
		$this->session->set_flashdata('message',$flashMsg);
        redirect(base_url('Broker/edit/'.encode_param($broker_id)));
	}
	
}