<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Driver extends CI_Controller {

	public function __construct() {
		parent::__construct();
		date_default_timezone_set("Asia/Kolkata");
		$this->load->model('Driver_model');
		$this->load->model('Company_model');
		
		if(!$this->session->userdata('logged_in')) {
			redirect(base_url('Login'));
		}
 	}
 	
	public function add_driver() {
		$template['page'] = 'Driver/add_driver';

		$template['menu'] = "Driver Management";
		$template['sub_menu'] = "Add Driver";

        $template['page_desc'] = "Add New Driver";
        $template['page_title'] = "Add Driver";

        $template['companies'] = $this->Company_model->getCompany();
		$this->load->view('template',$template);
	}

	public function driver_list() {
		$template['page'] = 'Driver/driver_list';

		$template['menu'] = "Driver Management";
		$template['sub_menu'] = "List Driver";

        $template['page_desc'] = "Driver List View";
        $template['page_title'] = "View Drivers";
        
        $template['drivers_data'] = $this->Driver_model->getDriver();

		$this->load->view('template',$template);
	}

	public function addDriver(){
		$err = 0;
		$errMsg = '';
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'error');
		if(!isset($_POST) || empty($_POST)){
			$this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Driver/add-driver'));
		}
		if($err == 0 && (!isset($_POST['first_name']) || empty($_POST['first_name']))){
			$err = 1;
			$errMsg = 'Provide a First Name';
		}else if($err == 0 && (!isset($_POST['last_name']) || empty($_POST['last_name']))){
			$err = 1;
			$errMsg = 'Provide a Last Name';
		}else if($err == 0 && (!isset($_POST['password']) || empty($_POST['password']))){
			$err = 1;
			$errMsg = 'Provide a Password';
		}else if($err == 0 && (!isset($_POST['phone']) || empty($_POST['phone']))){
			$err = 1;
			$errMsg = 'Provide a Phone Number';
		}else if($err == 0 && (!isset($_POST['email_id']) || empty($_POST['email_id']))){
			$err = 1;
			$errMsg = 'Provide an Email ID';
		}else if($err == 0 && (!isset($_POST['company_id']) || empty($_POST['company_id']))){
            $err = 1;
			$errMsg = 'Select a Company';
        }else if($err == 0 && (!isset($_FILES['licence']) || empty($_FILES['licence']))){
            $err = 1;
			$errMsg = 'Provide your Licence';
        }else if($err == 0 && (!isset($_FILES['profile_image']) || empty($_FILES['profile_image']))){
            $err = 1;
			$errMsg = 'Select a Profile Photo';
        }
        if($err == 0){
	        $config = set_upload_service("assets/uploads/services");
	        $this->load->library('upload');
	        $config['file_name'] = time()."_".$_FILES['profile_image']['name'];
	        $this->upload->initialize($config);
	        if(!$this->upload->do_upload('profile_image')){
	        	$err = 1;
				$errMsg = $this->upload->display_errors();
	        }else{
	            $upload_data = $this->upload->data();
	            $_POST['profile_image'] = $config['upload_path']."/".$upload_data['file_name'];
	        }

	        $config = set_upload_service("assets/uploads/services");
	        $this->load->library('upload');
	        $config['file_name'] = time()."_".$_FILES['licence']['name'];
	        $this->upload->initialize($config);
	        if(!$this->upload->do_upload('licence')){
	        	$err = 1;
				$errMsg = $this->upload->display_errors();
	        }else{
	            $upload_data = $this->upload->data();
	            $_POST['licence'] = $config['upload_path']."/".$upload_data['file_name'];
	        }
	    }
		if($err == 1){
			$flashMsg['message'] = $errMsg;
			$this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Driver/add_driver'));
		}
		$_POST['password'] = md5($_POST['password']);
		$status = $this->Driver_model->addDriver($_POST);
		if($status == 1){
			$flashMsg['class'] = 'success';
			$flashMsg['message'] = 'Driver Created';
		}else if($status == 2){
			$flashMsg['message'] = 'Email ID already in use.';
		}else if($status == 3){
			$flashMsg['message'] = 'Phone Number already in use.';
		}
		$this->session->set_flashdata('message',$flashMsg);
        redirect(base_url('Driver/add_driver'));
	}
	
	function changeStatus($driver_id = '',$status = '1'){
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'error');
		if(empty($driver_id)){
			$this->session->set_flashdata('message',$flashMsg);
        	redirect(base_url('Driver/Driver_list'));
		}
		$driver_id = decode_param($driver_id);
		$status = $this->Driver_model->changeStatus($driver_id,$status);
		if(!$status){
			$this->session->set_flashdata('message',$flashMsg);
		}
		redirect(base_url('Driver/Driver_list'));
	}

	function view($driver_id = ''){
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'error');
		if(empty($driver_id)){
			$this->session->set_flashdata('message',$flashMsg);
        	redirect(base_url('Driver/driver_list'));
		}
		$driver_id = decode_param($driver_id);

		$template['page'] = 'Driver/view';

		$template['menu'] = "Driver Management";
		$template['sub_menu'] = "Driver Profile";

        $template['page_desc'] = "View Driver Details";
        $template['page_title'] = "Driver Details";
        $template['driver_id'] = $driver_id;
        $template['driver_data'] = $this->Driver_model->getDriver($driver_id);

		$this->load->view('template',$template);
	}

	function edit($driver_id = ''){
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'error');
		if(empty($driver_id)){
			$this->session->set_flashdata('message',$flashMsg);
        	redirect(base_url('Driver/Driver_list'));
		}
		$driver_id = decode_param($driver_id);

		$template['page'] = 'Driver/edit';

		$template['menu'] = "Driver Management";
		$template['sub_menu'] = "Add Driver";

        $template['page_desc'] = "Edit Driver Details";
        $template['page_title'] = "Edit Driver";
        $template['driver_id'] = $driver_id;
        $template['driver_data'] = $this->Driver_model->getDriver($driver_id);
        $template['companies'] = $this->Company_model->getCompany();

		$this->load->view('template',$template);
	}

	function update($driver_id = ''){
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'error');
		if(empty($driver_id)){
			$this->session->set_flashdata('message',$flashMsg);
        	redirect(base_url('Driver/driver_list'));
		}
		$driver_id = decode_param($driver_id);

		$err = 0;
		$errMsg = '';
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'error');
		if(!isset($_POST) || empty($_POST)){
			$this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Driver/edit/'.encode_param($driver_id)));
		}
		if($err == 0 && (!isset($_POST['first_name']) || empty($_POST['first_name']))){
			$err = 1;
			$errMsg = 'Provide First Name';
		}else if($err == 0 && (!isset($_POST['last_name']) || empty($_POST['last_name']))){
			$err = 1;
			$errMsg = 'Provide Last Name';
		}else if($err == 0 && (!isset($_POST['email_id']) || empty($_POST['email_id']))){
			$err = 1;
			$errMsg = 'Provide an Email ID';
		}else if($err == 0 && (!isset($_POST['phone']) || empty($_POST['phone']))){
			$err = 1;
			$errMsg = 'Provide a Phone Number';
		}else if($err == 0 && (!isset($_POST['company_id']) || empty($_POST['company_id']))){
			$err = 1;
			$errMsg = 'Select a Company';
		}

		$_POST['profile_image'] = $_POST['licence'] = '';
		if(isset($_FILES['profile_image']) && !empty($_FILES['profile_image'])){
	        $config = set_upload_service("assets/uploads/services");
	        $this->load->library('upload');
	        $config['file_name'] = time()."_".$_FILES['profile_image']['name'];
	        $this->upload->initialize($config);
	        if($this->upload->do_upload('profile_image')){
	        	$upload_data = $this->upload->data();
	            $_POST['profile_image'] = $config['upload_path']."/".$upload_data['file_name'];
	        }
	    }
	    if(isset($_FILES['licence']) && !empty($_FILES['licence'])){
	        $config = set_upload_service("assets/uploads/services");
	        $this->load->library('upload');
	        $config['file_name'] = time()."_".$_FILES['licence']['name'];
	        $this->upload->initialize($config);
	        if($this->upload->do_upload('licence')){
	        	$upload_data = $this->upload->data();
	            $_POST['licence'] = $config['upload_path']."/".$upload_data['file_name'];
	        }
	    }

		if($err == 1){
			$flashMsg['message'] = $errMsg;
			$this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Driver/edit/'.encode_param($driver_id)));
		}

		$status = $this->Driver_model->updateDriver($driver_id,$_POST);
		if($status == 1){
			$flashMsg['class'] = 'success';
			$flashMsg['message'] = 'Driver Details Updated';
			$this->session->set_flashdata('message',$flashMsg);
			redirect(base_url('Driver/view/'.encode_param($driver_id)));
		}else if($status == 2){
			$flashMsg['message'] = 'Email ID already in use.';
		}else if($status == 3){
			$flashMsg['message'] = 'Phone Number already in use.';
		}
		$this->session->set_flashdata('message',$flashMsg);
        redirect(base_url('Driver/edit/'.encode_param($driver_id)));
	}
	
}