<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Ride extends CI_Controller {

	public function __construct() {
		parent::__construct();
		date_default_timezone_set("Asia/Kolkata");
		$this->load->model('Ride_model');
		
		if(!$this->session->userdata('logged_in')) {
			redirect(base_url('Login'));
		}
	}

	function import_ride(){
		$this->load->model('Broker_model');
		$this->load->model('Driver_model');
		$this->load->model('Vehicle_model');

		$template['page'] = 'Ride/add_transport';

		$template['menu'] = "Ride Management";
		$template['sub_menu'] = "Create/Import Rides";

		$template['page_desc'] = "Create/Import Ride data";
		$template['page_title'] = "Create/Import Ride";

		$template['trip_type'] = $this->Ride_model->getTripType();
		$template['driver_data'] = $this->Driver_model->getDriver();
		$template['broker_data'] = $this->Broker_model->getBroker();
		$template['vehicle_data'] = $this->Vehicle_model->getVehicle();
		$template['appointment_reason'] = $this->Ride_model->getAppReason();


		$this->load->view('template',$template);
	}

	function import(){
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'error');
		if(!isset($_FILES) || empty($_FILES) || !isset($_FILES['csv_file']) || empty($_FILES['csv_file']) || !isset($_POST) || empty($_POST) || !isset($_POST['broker_id']) || empty($_POST['broker_id'])){
			$this->session->set_flashdata('message',$flashMsg);
			redirect(base_url('Ride/import_ride'));
		}
		$header = 0;
		$insertArr = array(); 
		$headerArr = array();
		$insertData = array();
		if (($handle = fopen($_FILES['csv_file']['tmp_name'], "r")) !== FALSE) {
			while (($row = fgetcsv($handle, 1000, ",")) !== FALSE) {
				$colCnt = 0;
				$rowArr = array();
				foreach($row as $col){
					if($header == 0){
						$headerArr[] = $col;
					}else{
						$rowArr[][$headerArr[$colCnt]] = $col;
						$colCnt++;
					}
				}
				if($header != 0){
					$insertData = array('broker_id'=>$_POST['broker_id'],'medical_no'=>$row[0],'patient_name'=>$row[2].' '.$row[1],
						'age'=>$row[4],'phone'=>$row[5],'trip_no'=>$row[7],'appointment_time'=>$row[8].' '.$row[10],
						'reason_code'=>$row[11],'trip_cost'=>$row[22],'pickup_location'=>$row[23],'drop_location'=>$row[28],
						'trip_bid_status'=>$row[37],'trip_status'=>$row[12],'vehicle_type'=>$row[13],'trip_type'=>$row[14],
						'data'=>json_encode($rowArr));
					$insertArr[] = $insertData;
				}
				$header = 1;
			}
			fclose($handle);

			$status = $this->Ride_model->uploadRides($insertArr);
			if($status){
				$flashMsg['class'] = "success";
				$flashMsg['message'] = "Upload Scuccessfull";
			}
		}else{
			$flashMsg['message'] = "Please Choose a valid File";
		}
		$this->session->set_flashdata('message',$flashMsg);
		redirect(base_url('Ride/import_ride'));
	}

	function create_ride(){
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'error');
		if(!isset($_POST) || empty($_POST)){
			$this->session->set_flashdata('message',$flashMsg);
			redirect(base_url('Ride/import_ride'));
		}
		if($err == 0 && (!isset($_POST['medical_no']) || empty($_POST['medical_no']))){
			$err = 1;
			$errMsg = 'Medical Number';
		}else if($err == 0 && (!isset($_POST['age']) || empty($_POST['age']))){
			$err = 1;
			$errMsg = 'Age';
		}else if($err == 0 && (!isset($_POST['appointment_date']) || empty($_POST['appointment_date']))){
			$err = 1;
			$errMsg = 'Appointment date';
		}else if($err == 0 && (!isset($_POST['trip_cost']) || empty($_POST['trip_cost']))){
			$err = 1;
			$errMsg = 'Trip Cost';
		}else if($err == 0 && (!isset($_POST['vehicle_type']) || empty($_POST['vehicle_type']))){
			$err = 1;
			$errMsg = 'Vechile Type';
		}else if($err == 0 && (!isset($_POST['first_name']) || empty($_POST['first_name']))){
			$err = 1;
			$errMsg = 'Name';
		}else if($err == 0 && (!isset($_POST['phone']) || empty($_POST['phone']))){
			$err = 1;
			$errMsg = 'Phone Number';
		}else if($err == 0 && (!isset($_POST['appointment_time']) || empty($_POST['appointment_time']))){
			$err = 1;
			$errMsg = 'Appointment Time';
		}else if($err == 0 && (!isset($_POST['pickup_location']) || empty($_POST['pickup_location']))){
			$err = 1;
			$errMsg = 'Pickup Location';
		}else if($err == 0 && (!isset($_POST['trip_type']) || empty($_POST['trip_type']))){
			$err = 1;
			$errMsg = 'Trip Type';
		}else if($err == 0 && (!isset($_POST['last_name']) || empty($_POST['last_name']))){
			$err = 1;
			$errMsg = 'Name';
		}else if($err == 0 && (!isset($_POST['reason_code']) || empty($_POST['reason_code']))){
			$err = 1;
			$errMsg = 'Reason';
		}else if($err == 0 && (!isset($_POST['drop_location']) || empty($_POST['drop_location']))){
			$err = 1;
			$errMsg = 'Drop Location';
		}
		if(!isset($_POST['driver_id']) || empty($_POST['driver_id'])){
			unset($_POST['driver_id']);
		}
		if($err == 1){
			$flashMsg['message'] = $errMsg." is mandatory";
			$this->session->set_flashdata('message',$flashMsg);
			redirect(base_url('Ride/import_ride'));
		}
		$data = array("Appointment Date"=>$_POST['appointment_date'],"Appointment Time"=>$_POST['appointment_time'],"Member's First Name"=>$_POST['first_name'],"Member's Last Name"=>$_POST['last_name']);
		$_POST['patient_name'] = $_POST['first_name'].' '.$_POST['last_name'];
		$_POST['appointment_time'] = $_POST['appointment_date'].' '.$_POST['appointment_time'];

		$data['Pregnant Flag'] = (isset($_POST['pregnant_flag']))?1:0;
		$data['Attendant Flag'] = (isset($_POST['attendant_flag']))?1:0;
		$data['Wheelchair Flag'] = (isset($_POST['wheelchair_flag']))?1:0;
		$data['Crutches / Walker / Cane Flag'] = (isset($_POST['c_w_c_flag']))?1:0;
		
		unset($_POST['first_name']);
		unset($_POST['last_name']);
		unset($_POST['c_w_c_flag']);
		unset($_POST['pregnant_flag']);
		unset($_POST['attendant_flag']);
		unset($_POST['wheelchair_flag']);
		unset($_POST['appointment_date']);
		$_POST['data'] = json_encode($data);
		$status = $this->Ride_model->create_ride($_POST);
		if($status){
			$flashMsg['class'] = "success";
			$flashMsg['message'] = "Upload Scuccessfull";
		}
		$this->session->set_flashdata('message',$flashMsg);
		redirect(base_url('Ride/import_ride'));
	}

	function view_rides(){
		$template['page'] = 'Ride/view_rides';

		$template['menu'] = "Ride Management";
		$template['sub_menu'] = "View Rides";

		$template['page_desc'] = "View Rides Details";
		$template['page_title'] = "View Rides";

		$template['ride_data'] = $this->Ride_model->getRideData();

		$this->load->view('template',$template);
	}

	function changeStatus($ride_id = '',$status = '1'){
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'error');
		if(empty($ride_id)){
			$this->session->set_flashdata('message',$flashMsg);
        	redirect(base_url('Ride/view_rides'));
		}
		$ride_id = decode_param($ride_id);
		$status = $this->Ride_model->changeStatus($ride_id,$status);
		if(!$status){
			$this->session->set_flashdata('message',$flashMsg);
		}
		redirect(base_url('Ride/view_rides'));
	}

	function view($ride_id = ''){
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'error');
		if(empty($ride_id)){
			$this->session->set_flashdata('message',$flashMsg);
        	redirect(base_url('Ride/view_rides'));
		}
		$ride_id = decode_param($ride_id);

		$template['page'] = 'Ride/view';

		$template['menu'] = "Ride Management";
		$template['sub_menu'] = "View Ride Details";

		$template['page_desc'] = "View Ride Details";
		$template['page_title'] = "Ride Details";

		$ride_data = $this->Ride_model->getRideData($ride_id);
		if(empty($ride_data) || !isset($ride_data->data) || empty($ride_data->data)){
			$this->session->set_flashdata('message',$flashMsg);
        	redirect(base_url('Ride/view_rides'));
		}
		$template['ride_data'] = json_decode($ride_data->data,true);
		$this->load->view('template',$template);
	}
}