<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class User extends CI_Controller {

	public function __construct() {
		parent::__construct();
		date_default_timezone_set("Asia/Kolkata");
		$this->load->model('User_model');
		$this->load->model('Dashboard_model');
		
		if(!$this->session->userdata('logged_in')) {
			redirect(base_url('Login'));
		}
 	}
	
	public function viewProfile($user_id = '') {
		if(empty($user_id)){
			redirect(base_url());
		}
		$user_id = decode_param($user_id);

		$template['page'] = 'User/viewProfile';
        $template['page_desc'] = "Edit or View Profile";
        $template['page_title'] = "User Profile";
		$template['user_data'] = $this->User_model->getUserData($user_id);

		$this->load->view('template',$template);
	}
}
?>