<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Vehicle extends CI_Controller {

	public function __construct() {
		parent::__construct();
		date_default_timezone_set("Asia/Kolkata");
		$this->load->model('Vehicle_model');
		
		if(!$this->session->userdata('logged_in')) {
			redirect(base_url('Login'));
		}
 	}
 	
	public function add_vehicle() {
		$template['page'] = 'Vehicle/add_vehicle';

		$template['menu'] = "Vehicle Management";
		$template['sub_menu'] = "Add Vehicle";

        $template['page_desc'] = "Add New Vehicle";
        $template['page_title'] = "Add Vehicle";

		$this->load->view('template',$template);
	}

	public function view_vehicles() {
		$template['page'] = 'Vehicle/view_vehicle';

		$template['menu'] = "Vehicle Management";
		$template['sub_menu'] = "List Vehicles";

        $template['page_desc'] = "Vehicles List View";
        $template['page_title'] = "View Vehicles";
        
        $template['vehicles_data'] = $this->Vehicle_model->getVehicle();

		$this->load->view('template',$template);
	}

	public function addVehicle(){
		$err = 0;
		$errMsg = '';
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'error');
		if(!isset($_POST) || empty($_POST)){
			$this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Vehicle/add_vehicle'));
		}
		if($err == 0 && (!isset($_POST['vehicle_type']) || empty($_POST['vehicle_type']))){
			$err = 1;
			$errMsg = 'Provide a Vehicle Type';
		}
		if($err == 1){
			$flashMsg['message'] = $errMsg;
			$this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Vehicle/add_vehicle'));
		}
		if($err == 0){
	        $config = set_upload_service("assets/uploads/services");
	        $this->load->library('upload');
	        $config['file_name'] = time()."_".$_FILES['vehicle_photo']['name'];
	        $this->upload->initialize($config);
	        if(!$this->upload->do_upload('vehicle_photo')){
	        	$err = 1;
				$errMsg = $this->upload->display_errors();
	        }else{
	            $upload_data = $this->upload->data();
	            $_POST['vehicle_photo'] = $config['upload_path']."/".$upload_data['file_name'];
	        }
	    }
		$status = $this->Vehicle_model->addVehicle($_POST);
		if($status == 1){
			$flashMsg['class'] = 'success';
			$flashMsg['message'] = 'Vehicle Created';
		}else if($status == 2){
			$flashMsg['message'] = 'Vehicle Type already exist.';
		}
		$this->session->set_flashdata('message',$flashMsg);
        redirect(base_url('Vehicle/add_vehicle'));
	}
	
	function changeStatus($vehicle_id = '',$status = '1'){
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'error');
		if(empty($vehicle_id)){
			$this->session->set_flashdata('message',$flashMsg);
        	redirect(base_url('Vehicle/view_vehicles'));
		}
		$vehicle_id = decode_param($vehicle_id);
		$status = $this->Vehicle_model->changeStatus($vehicle_id,$status);
		if(!$status){
			$this->session->set_flashdata('message',$flashMsg);
		}
		redirect(base_url('Vehicle/view_vehicles'));
	}

	function edit($vehicle_id = ''){
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'error');
		if(empty($vehicle_id)){
			$this->session->set_flashdata('message',$flashMsg);
        	redirect(base_url('Vehicle/view_vehicles'));
		}
		$vehicle_id = decode_param($vehicle_id);

		$template['page'] = 'Vehicle/edit';

		$template['menu'] = "Vehicle Management";
		$template['sub_menu'] = "Edit Vehicle";

        $template['page_desc'] = "Edit Vehicle Details";
        $template['page_title'] = "Edit Vehicle";
        $template['vehicle_id'] = $vehicle_id;
        $template['vehicle_data'] = $this->Vehicle_model->getVehicle($vehicle_id);

		$this->load->view('template',$template);
	}

	function update($vehicle_id = ''){
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'error');
		if(empty($vehicle_id)){
			$this->session->set_flashdata('message',$flashMsg);
        	redirect(base_url('Vehicle/view_vehicles'));
		}
		$vehicle_id = decode_param($vehicle_id);

		$err = 0;
		$errMsg = '';
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'error');
		if(!isset($_POST) || empty($_POST)){
			$this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Vehicle/edit/'.encode_param($vehicle_id)));
		}
		if($err == 0 && (!isset($_POST['vehicle_type']) || empty($_POST['vehicle_type']))){
			$err = 1;
			$errMsg = 'Provide a Vehicle Type';
		}
		if($err == 1){
			$flashMsg['message'] = $errMsg;
			$this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Vehicle/edit/'.encode_param($vehicle_id)));
		}
		$_POST['vehicle_photo'] = '';
		if(isset($_FILES['vehicle_photo']) && !empty($_FILES['vehicle_photo'])){
	        $config = set_upload_service("assets/uploads/services");
	        $this->load->library('upload');
	        $config['file_name'] = time()."_".$_FILES['vehicle_photo']['name'];
	        $this->upload->initialize($config);
	        if($this->upload->do_upload('vehicle_photo')){
	        	$upload_data = $this->upload->data();
	            $_POST['vehicle_photo'] = $config['upload_path']."/".$upload_data['file_name'];
	        }
	    }

		$status = $this->Vehicle_model->updateVehicle($vehicle_id,$_POST);
		if($status == 1){
			$flashMsg['class'] = 'success';
			$flashMsg['message'] = 'Vehicle Details Updated';
			$this->session->set_flashdata('message',$flashMsg);
			redirect(base_url('Vehicle/view_vehicles'));
		}else if($status == 2){
			$flashMsg['message'] = 'Vehicle Type already in use.';
		}
		$this->session->set_flashdata('message',$flashMsg);
        redirect(base_url('Vehicle/edit/'.encode_param($vehicle_id)));
	}
	
}