<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Company extends CI_Controller {

	public function __construct() {
		parent::__construct();
		date_default_timezone_set("Asia/Kolkata");
		$this->load->model('Company_model');
		
		if(!$this->session->userdata('logged_in')) {
			redirect(base_url('Login'));
		}
 	}
	
	
	public function add_company() {
		$template['page'] = 'Company/add_company';

		$template['menu'] = "Company Management";
		$template['sub_menu'] = "Add Company";

        $template['page_desc'] = "Add New Company";
        $template['page_title'] = "Add Company";
        
		$this->load->view('template',$template);
	}

	public function company_list() {
		$template['page'] = 'Company/company_list';
        $template['page_desc'] = "Company List View";
        $template['page_title'] = "View Companies";
        
		$template['menu'] = "Company Management";
		$template['sub_menu'] = "View Companies";

        $template['company_data'] = $this->Company_model->getCompany();

		$this->load->view('template',$template);
	}

	public function addCompany(){
		$err = 0;
		$errMsg = '';
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'error');
		if(!isset($_POST) || empty($_POST)){
			$this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Company/add_company'));
		}
		if($err == 0 && (!isset($_POST['company_name']) || empty($_POST['company_name']))){
			$err = 1;
			$errMsg = 'Provide a Company Name';
		}else if($err == 0 && (!isset($_POST['email_id']) || empty($_POST['email_id']))){
			$err = 1;
			$errMsg = 'Provide an Email ID';
		}else if($err == 0 && (!isset($_POST['password']) || empty($_POST['password']))){
			$err = 1;
			$errMsg = 'Provide a Password';
		}else if($err == 0 && (!isset($_POST['address']) || empty($_POST['address']))){
			$err = 1;
			$errMsg = 'Provide an Address';
		}else if($err == 0 && (!isset($_POST['fax']) || empty($_POST['fax']))){
			$err = 1;
			$errMsg = 'Provide a Fax Number';
		}else if($err == 0 && (!isset($_POST['phone']) || empty($_POST['phone']))){
			$err = 1;
			$errMsg = 'Provide a Phone Number';
		}else if($err == 0 && (!isset($_POST['company_contact']) || empty($_POST['company_contact']))){
			$err = 1;
			$errMsg = 'Provide a Company Contact Number';
		}else if($err == 0 && (!isset($_POST['company_info']) || empty($_POST['company_info']))){
			$err = 1;
			$errMsg = 'Provide a Contact Person Info.';
		}else if($err == 0 && (!isset($_FILES['profile_image']) || empty($_FILES['profile_image']))){
            $err = 1;
			$errMsg = 'Provide a Profile Picture';
        }
        $config = set_upload_service("assets/uploads/services");
        $this->load->library('upload');
        $config['file_name'] = time()."_".$_FILES['profile_image']['name'];
        $this->upload->initialize($config);
        if(!$this->upload->do_upload('profile_image')){
        	$err = 1;
			$errMsg = $this->upload->display_errors();
        }else{
            $upload_data = $this->upload->data();
            $_POST['profile_image'] = $config['upload_path']."/".$upload_data['file_name'];
        }

		if($err == 1){
			$flashMsg['message'] = $errMsg;
			$this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Company/add_company'));
		}

		$status = $this->Company_model->addCompany($_POST);
		if($status == 1){
			$flashMsg['class'] = 'success';
			$flashMsg['message'] = 'Company Created';
		}else if($status == 2){
			$flashMsg['message'] = 'Email ID already in use.';
		}
		$this->session->set_flashdata('message',$flashMsg);
        redirect(base_url('Company/add_company'));
	}
	
	function changeStatus($company_id = '',$status = '1'){
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'error');
		if(empty($company_id)){
			$this->session->set_flashdata('message',$flashMsg);
        	redirect(base_url('Company/company_list'));
		}
		$company_id = decode_param($company_id);
		$status = $this->Company_model->changeStatus($company_id,$status);
		if(!$status){
			$this->session->set_flashdata('message',$flashMsg);
		}
		redirect(base_url('Company/company_list'));
	}

	function view($company_id = ''){
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'error');
		if(empty($company_id)){
			$this->session->set_flashdata('message',$flashMsg);
        	redirect(base_url('Company/company_list'));
		}
		$company_id = decode_param($company_id);

		$template['page'] = 'Company/view';
        $template['page_desc'] = "Company Details";

		$template['menu'] = "Company Management";
		$template['sub_menu'] = "Company Profile";

        $template['page_title'] = "View Company Details";
        $template['company_id'] = $company_id;
        $template['company_data'] = $this->Company_model->getCompany($company_id);

		$this->load->view('template',$template);
	}

	function edit($company_id = ''){
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'error');
		if(empty($company_id)){
			$this->session->set_flashdata('message',$flashMsg);
        	redirect(base_url('Company/company_list'));
		}
		$company_id = decode_param($company_id);

		$template['page'] = 'Company/edit';
        $template['page_desc'] = "Edit Company Details";

		$template['menu'] = "Company Management";
		$template['sub_menu'] = "Edit Company";

        $template['page_title'] = "Edit Company";
        $template['company_id'] = $company_id;
        $template['company_data'] = $this->Company_model->getCompany($company_id);

		$this->load->view('template',$template);
	}

	function update($company_id = ''){
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'error');
		if(empty($company_id)){
			$this->session->set_flashdata('message',$flashMsg);
        	redirect(base_url('Company/company_list'));
		}
		$company_id = decode_param($company_id);

		$err = 0;
		$errMsg = '';
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'error');
		if(!isset($_POST) || empty($_POST)){
			$this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Company/edit/'.encode_param($company_id)));
		}
		if($err == 0 && (!isset($_POST['company_name']) || empty($_POST['company_name']))){
			$err = 1;
			$errMsg = 'Provide a Company Name';
		}else if($err == 0 && (!isset($_POST['email_id']) || empty($_POST['email_id']))){
			$err = 1;
			$errMsg = 'Provide an Email ID';
		}else if($err == 0 && (!isset($_POST['address']) || empty($_POST['address']))){
			$err = 1;
			$errMsg = 'Provide an Address';
		}else if($err == 0 && (!isset($_POST['fax']) || empty($_POST['fax']))){
			$err = 1;
			$errMsg = 'Provide a Fax Number';
		}else if($err == 0 && (!isset($_POST['phone']) || empty($_POST['phone']))){
			$err = 1;
			$errMsg = 'Provide a Phone Number';
		}else if($err == 0 && (!isset($_POST['company_contact']) || empty($_POST['company_contact']))){
			$err = 1;
			$errMsg = 'Provide a Company Contact Number';
		}else if($err == 0 && (!isset($_POST['company_info']) || empty($_POST['company_info']))){
			$err = 1;
			$errMsg = 'Provide a Contact Person Info.';
		}
		$_POST['profile_image'] = '';
		if(isset($_FILES['profile_image']) && !empty($_FILES['profile_image'])){
	        $config = set_upload_service("assets/uploads/services");
	        $this->load->library('upload');
	        $config['file_name'] = time()."_".$_FILES['profile_image']['name'];
	        $this->upload->initialize($config);
	        if($this->upload->do_upload('profile_image')){
	        	$upload_data = $this->upload->data();
	            $_POST['profile_image'] = $config['upload_path']."/".$upload_data['file_name'];
	        }
	    }

		if($err == 1){
			$flashMsg['message'] = $errMsg;
			$this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Company/edit/'.encode_param($company_id)));
		}

		$status = $this->Company_model->updateCompany($company_id,$_POST);
		if($status == 1){
			$flashMsg['class'] = 'success';
			$flashMsg['message'] = 'Company Details Updated';
			$this->session->set_flashdata('message',$flashMsg);
			redirect(base_url('Company/view/'.encode_param($company_id)));
		}else if($status == 2){
			$flashMsg['message'] = 'Email ID already in use.';
		}
		$this->session->set_flashdata('message',$flashMsg);
        redirect(base_url('Company/edit/'.encode_param($company_id)));
	}
	
}
?>