<div class="content-wrapper">
 <section class="content-header">
  <h1>
    <?= $page_title ?>
    <small><?= $page_desc ?></small>
  </h1>
  <ol class="breadcrumb">
   <li><a href="<?= base_url() ?>"><i class="fa fa-star-o" aria-hidden="true"></i>Home</a></li>
   <li><?= $menu ?></li>
   <li class="active"><?= $sub_menu ?></li>
 </ol>
</section>
<section class="content">
  <div class="row">
     <div class="col-md-12">
      <?php if($this->session->flashdata('message')) { 
        $flashdata = $this->session->flashdata('message'); ?>
        <div class="alert alert-<?= $flashdata['class'] ?>">
         <button class="close" data-dismiss="alert" type="button">×</button>
         <?= $flashdata['message'] ?>
       </div>
     <?php } ?>
   </div>
   <div class="col-md-12">
    <div class="box box-warning">
     <div class="box-header with-border">
       <h3 class="box-title">Company Details</h3>
     </div>
      <form role="form" action="<?=base_url('Driver/addDriver')?>" method="post" class="validate" data-parsley-validate="" enctype="multipart/form-data">
        <div class="box-body">
          <div class="col-md-6">
           <div class="form-group has-feedback">
             <label for="exampleInputEmail1">First Name</label>
             <input type="text" class="form-control required" data-parsley-trigger="change"  
             data-parsley-minlength="2"  data-parsley-pattern="^[a-zA-Z\ . ! @ # $ % ^ & * () + = , \/]+$" required="" name="first_name"  placeholder="Enter Company Name">
             <span class="glyphicon  form-control-feedback"></span>
           </div>
           <div class="form-group has-feedback">
             <label for="exampleInputEmail1">Last Name</label>
             <input type="text" class="form-control required" data-parsley-trigger="change"  
             data-parsley-minlength="2"  data-parsley-pattern="^[a-zA-Z\ . ! @ # $ % ^ & * () + = , \/]+$" required="" name="last_name"  placeholder="Enter Company Name">
             <span class="glyphicon  form-control-feedback"></span>
           </div>
           <div class="form-group has-feedback">
             <label for="exampleInputEmail1">Email</label>
             <input type="email" class="form-control required" data-parsley-trigger="change"  
             data-parsley-minlength="2"  required="" name="email_id" placeholder="Enter email ID">
             <span class="glyphicon  form-control-feedback"></span>
           </div> 
           <div class="form-group has-feedback">
             <label for="exampleInputEmail1">Password</label>
             <input type="password" class="form-control required" data-parsley-trigger="change"  
             data-parsley-minlength="2"  required="" name="password"  placeholder="Enter Pasword">
             <span class="glyphicon  form-control-feedback"></span>
           </div>         
           <div class="col-md-12">          
            <div class="box-footer">
              <button type="submit" class="btn btn-primary">Submit</button>
            </div>        
          </div>     
        </div>
        <div class="col-md-6">
          <div class="form-group">
            <label for="exampleInputEmail1">Licence</label>
            <div class="col-md-12">
              <div class="col-md-3">
                <img id="licence_img" src="" onerror="this.src='<?=base_url("assets/images/no_image.png")?>';" height="75" width="75" />
              </div>
              <div class="col-md-9" style="padding-top: 25px;">
                <input name="licence" type="file" accept="image/*" class="required" onchange="setImg(this,'licence_img');" />
              </div>
            </div>
          </div>
         <div class="form-group">
          <label for="exampleInputEmail1">Company</label>
          <select name="company_id" class="form-control required" data-parsley-trigger="change" required>
              <option selected disabled>Select Company</option>
              <?php 
                if(!empty($companies)){
                  foreach ($companies as $company) {
                    echo '<option value="'.$company->company_id.'">'.$company->company_name.'</option>';
                  } 
                }
              ?>
            </select> 
         </div>
         <div class="form-group">
           <label for="exampleInputEmail1">Phone</label>
           <input type="number" class="form-control required" data-parsley-trigger="change"  
             data-parsley-minlength="2"  required="" name="phone" placeholder="Enter Phone Number">
             <span class="glyphicon  form-control-feedback"></span> 
         </div>
         <div class="form-group">
            <label for="exampleInputEmail1">Profile Picture</label>
            <div class="col-md-12">
              <div class="col-md-3">
                <img id="profile_image" src="" onerror="this.src='<?=base_url("assets/images/user_avatar.jpg")?>';" height="75" width="75" />
              </div>
              <div class="col-md-9" style="padding-top: 25px;">
                <input name="profile_image" type="file" accept="image/*" class="required" onchange="setImg(this,'profile_image');" />
              </div>
            </div>
          </div>
        </div> 
      </form>
    </div>
  </section>
</div>