<div class="content-wrapper">
  <section class="content-header">
    <h1>
      <?= $page_title ?>
      <small><?= $page_desc ?></small>
    </h1>
    <ol class="breadcrumb">
     <li><a href="<?= base_url() ?>"><i class="fa fa-star-o" aria-hidden="true"></i>Home</a></li>
     <li><?= $menu ?></li>
     <li class="active"><?= $sub_menu ?></li>
   </ol>
  </section>
  <section class="content">
    <div class="row">
      <div class="col-md-12">
        <?php if($this->session->flashdata('message')) { 
          $flashdata = $this->session->flashdata('message'); ?>
          <div class="alert alert-<?= $flashdata['class'] ?>">
           <button class="close" data-dismiss="alert" type="button">×</button>
           <?= $flashdata['message'] ?>
          </div>
        <?php } ?>
      </div>
      <div class="col-md-12">
        <div class="box box-warning">
          <div class="box-header with-border">
            <h3 class="box-title">Create Ride</h3>
          </div>
          <form role="form" action="<?=base_url('Ride/create_ride')?>" method="post" class="validate" data-parsley-validate="" enctype="multipart/form-data">
            <div class="box-body">
              <div class="col-md-12"> 
                <div class="col-md-4"> 
                  <!-- 1 - 1 -->
                  <div class="form-group has-feedback">
                    <label>Medical Number</label>
                    <input type="text" class="form-control required" data-parsley-trigger="change"  
                    data-parsley-minlength="2"  data-parsley-pattern="^[a-zA-Z0-9\ . ! @ # $ % ^ & * () + = , \/]+$" required="" name="medical_no"  placeholder="Enter Medical Number">
                    <span class="glyphicon  form-control-feedback"></span>
                  </div>
                  <!-- 1 - 2 -->
                  <div class="form-group has-feedback">
                    <label>Age</label>
                    <input type="text" class="form-control required" data-parsley-trigger="change"  
                    data-parsley-minlength="2"  data-parsley-pattern="^[0-9]+$" required="" name="age"  placeholder="Enter Age">
                    <span class="glyphicon  form-control-feedback"></span>
                  </div>
                  <!-- 1 - 3 -->     
                  <div class="form-group has-feedback">
                    <label>Appointment Date</label>
                    <div class="input-group date" data-provide="datepicker">
                      <input id="datepicker" type="text" class="form-control required" data-parsley-trigger="change" data-parsley-minlength="2" required="" name="appointment_date" placeholder="Pick Appointment Date">
                      <div class="input-group-addon">
                        <i class="fa fa-calendar"></i>
                      </div>
                    </div>
                  </div>
                  <!-- 1 - 4 -->
                  <div class="form-group has-feedback">
                    <label>Pickup Location</label>
                    <input type="text" class="form-control required" data-parsley-trigger="change" required="" id="pickup_location" name="pickup_location" placeholder="Select Pickup Location">
                    <span class="glyphicon  form-control-feedback"></span>
                  </div>
                  <!-- 1 - 5 -->
                  <div class="form-group has-feedback">
                    <label>Trip Cost</label>
                    <input type="text" class="form-control required" data-parsley-trigger="change"  
                    data-parsley-minlength="2"  data-parsley-pattern="^[0-9 , . ]+$" required="" name="trip_cost"  placeholder="Enter Trip Cost">
                    <span class="glyphicon  form-control-feedback"></span>
                  </div>
                </div>
                <div class="col-md-4">
                  <!-- 2 - 1 -->
                  <div class="form-group has-feedback">
                    <label>First Name</label>
                    <input type="text" class="form-control required" data-parsley-trigger="change"  
                    data-parsley-minlength="2"  data-parsley-pattern="^[a-zA-Z\ . ! @ # $ % ^ & * () + = , \/]+$" required="" name="first_name"  placeholder="Enter First Name">
                    <span class="glyphicon  form-control-feedback"></span>
                  </div>
                  <!-- 2 - 2 -->
                  <div class="form-group has-feedback">
                    <label>Phone Number</label>
                    <input type="text" class="form-control required" data-parsley-trigger="change"  
                    data-parsley-minlength="2" required="" name="phone"  placeholder="Enter Phone Number">
                    <span class="glyphicon  form-control-feedback"></span>
                  </div>
                  <!-- 2 - 3 -->
                  <div class="form-group has-feedback clockpicker" data-placement="right" data-align="top" data-autoclose="true">
                    <label>Appointment Time</label>
                    <div class="input-group date" id='timepicker'>
                        <input type="text" class="form-control required" data-parsley-trigger="change" data-parsley-minlength="2" required="" name="appointment_time" placeholder="Pick Appointment Time">
                        <div class="input-group-addon">
                          <i class="fa fa-clock-o"></i>
                        </div>
                      </div>
                  </div>
                  <!-- 2 - 4 -->
                  <div class="form-group has-feedback">
                    <label>Drop Location</label>
                    <input type="text" class="form-control required" data-parsley-trigger="change"  
                    required="" id="drop_location" name="drop_location" placeholder="Select Drop Location">
                    <span class="glyphicon  form-control-feedback"></span>
                  </div>
                  <!-- 2 - 5 -->
                  <div class="form-group has-feedback">
                    <label>Trip Type</label>
                    <select name="trip_type" class="form-control required" data-parsley-trigger="change" required>
                      <option selected disabled>Select Trip Type</option>
                      <?php 
                        if(!empty($trip_type)){
                          foreach ($trip_type as $type) {
                            echo '<option value="'.$type->trip_id.'">'.$type->trip_type.'</option>';
                          } 
                        }
                      ?>
                    </select> 
                  </div>
                </div>
                <div class="col-md-4">
                  <!-- 3 - 1 -->
                  <div class="form-group has-feedback">
                    <label>Last Name</label>
                    <input type="text" class="form-control required" data-parsley-trigger="change"  
                    data-parsley-minlength="2"  data-parsley-pattern="^[a-zA-Z\ . ! @ # $ % ^ & * () + = , \/]+$" required="" name="last_name"  placeholder="Enter Last Name">
                    <span class="glyphicon  form-control-feedback"></span>
                  </div>
                  <!-- 3 - 2 -->
                  <div class="form-group has-feedback">
                    <label>Preferred Driver</label>
                    <select name="driver_id" class="form-control" data-parsley-trigger="change">
                      <option selected>Select Preferred Driver (If any)</option>
                      <?php 
                        if(!empty($driver_data)){
                          foreach ($driver_data as $driver) {
                            echo '<option value="'.$driver->driver_id.'">'.$driver->first_name.' '.$driver->last_name.'</option>';
                          } 
                        }
                      ?>
                    </select> 
                  </div>
                  <!-- 3 - 3 -->
                  <div class="form-group has-feedback">
                    <label>Reason</label>
                    <select name="reason_code" class="form-control required" data-parsley-trigger="change" required>
                      <option selected disabled>Select Reason</option>
                      <?php 
                        if(!empty($appointment_reason)){
                          foreach ($appointment_reason as $reason) {
                            echo '<option value="'.$reason->reason_id.'">'.$reason->reason.'</option>';
                          } 
                        }
                      ?>
                    </select> 
                  </div>
                  <!-- 3 - 4 -->
                  <div class="form-group has-feedback">
                    <label>Vehicle Type</label>
                    <select name="vehicle_type" class="form-control required" data-parsley-trigger="change" required>
                      <option selected disabled>Select Vehicle Type</option>
                      <?php 
                        if(!empty($vehicle_data)){
                          foreach ($vehicle_data as $vehicle) {
                            echo '<option value="'.$vehicle->vehicle_id.'">'.$vehicle->vehicle_type.'</option>';
                          } 
                        }
                      ?>
                    </select> 
                  </div>
                </div>
              </div>
              <div class="col-md-12">          
                <div class="col-md-2">
                  <input type="checkbox" name="wheelchair_flag" value="1">
                  <label style="padding-left: 10px;">Wheelchair</label>
                </div>         
                <div class="col-md-2">
                  <input type="checkbox" name="pregnant_flag" value="1">
                  <label style="padding-left: 10px;">Pregnant</label>
                </div>          
                <div class="col-md-2">
                  <input type="checkbox" name="attendant_flag" value="1">
                  <label style="padding-left: 10px;">Attendant</label>
                </div>          
                <div class="col-md-6">
                  <input type="checkbox" name="c_w_c_flag" value="1">
                  <label style="padding-left: 10px;">Crutches / Walker / Cane Flag</label>
                </div>   
              </div> 
              <div class="col-md-12">          
                <div class="box-footer">
                  <button type="submit" class="btn btn-primary">Submit</button>
                </div>        
              </div> 
            </div>
          </form>
        </div>
      </div>
      <div class="col-md-12">
        <div class="box box-warning">
          <div class="box-header with-border">
            <h3 class="box-title">Upload Ride</h3>
          </div>
          <form role="form" action="<?=base_url('Ride/import')?>" method="post" class="validate" data-parsley-validate="" enctype="multipart/form-data">
            <br>
            <div class="box-body">
                <div class="col-md-12">  
                    <div class="col-md-5">
                        <div class="form-group has-feedback">
                            <label>Choose Broker</label>
                            <select name="broker_id" class="form-control required" data-parsley-trigger="change" required>
                              <option selected disabled>Select Broker</option>
                              <?php 
                                if(!empty($broker_data)){
                                  foreach ($broker_data as $broker) {
                                    echo '<option value="'.$broker->broker_id.'">'.$broker->broker_name.'</option>';
                                  } 
                                }
                              ?>
                            </select> 
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group has-feedback">
                            <label>CSV File</label>
                            <input name="csv_file" type="file" accept=".csv" class="required"  />
                        </div>
                    </div>
                </div>
                <div class="col-md-12">          
                    <div class="box-footer">
                      <button type="submit" class="btn btn-primary">Upload</button>
                    </div>        
                </div> 
            </div>
            <br>
          </form>
        </div>
      </div>
    </div>
  </section>
</div>