<div class="content-wrapper" >
 <!-- Content Header (Page header) -->
 <section class="content-header">
  <h1>
     <?= $page_title ?>
      <small><?= $page_desc ?></small>
  </h1>
  <ol class="breadcrumb">
   <li><a href="<?= base_url() ?>"><i class="fa fa-star-o" aria-hidden="true"></i>Home</a></li>
   <li>User</li>
   <li class="active">View User</li>
 </ol>
</section>
<!-- Main content -->
<section class="content">
  <div class="row">
    <div class="col-md-12">
        <?php if($this->session->flashdata('message')) { 
            $flashdata = $this->session->flashdata('message'); ?>
            <div class="alert alert-<?= $flashdata['class'] ?>">
               <button class="close" data-dismiss="alert" type="button">×</button>
               <?= $flashdata['message'] ?>
            </div>
        <?php } ?>
   </div>
   <div class="col-xs-12">
    <div class="box">
     <div class="box-header">
      <h3 class="box-title">View User Details</h3>
    </div>
    <div class="box-body">
      <table id="" class="table table-bordered table-striped datatable ">
       <thead>
        <tr>
         <th class="hidden">ID</th>
         <th width="150px;">Patient Name</th> 
         <th width="50px;">Age</th> 
         <th width="100px;">Phone</th>
         <th width="150px;">Appintment Date</th>
         <th width="150px;">Status</th>
         <th width="150px;">Data Source</th>
         <th width="300px;">Action</th>
       </tr>
     </thead> 
     <tbody>
      <?php
      if(!empty($ride_data)){
        foreach($ride_data as $ride) {
         ?>
         <tr>
           <th class="hidden"><?= $ride->transport_id ?></th>
           <td class="center"><?= $ride->patient_name ?></th> 
           <td class="center"><?= $ride->age ?></th> 
           <td class="center"><?= $ride->phone ?></th>
           <td class="center"><?= date('d-M-Y G:i',strtotime($ride->appointment_time)) ?></th>
           <td class="center">
            <?php
              switch ($ride->status){
                case 0: echo 'Inactive';break;
                case 1: echo 'Waiting For Drivers';break;
                case 3: echo 'Driver Accepted';break;
                case 4: echo 'Ride Completed';break;
                case 4: echo 'Ride Cancelled';break;
              }
            ?>
           </td>
           <td class="center"><?= (!empty($ride->broker_name)?$ride->broker_name:'Phone Booking') ?></th>
           <td class="center">   
              <a class="btn btn-sm btn-primary" 
                href="<?= base_url('Ride/view/'.encode_param($ride->transport_id)) ?>">
                <i class="fa fa-fw fa-edit"></i>View
              </a>
              <a class="btn btn-sm btn-danger" 
                href="<?= base_url("Ride/changeStatus/".encode_param($ride->transport_id))."/2" ?>" 
                onClick="return doconfirm()">
                <i class="fa fa-fw fa-trash"></i>Delete
              </a>
              <?php if($ride->status == 1 && date('Ymd Gi') < $ride->appointment_time){?>
                <a class="btn btn-sm btn-primary" 
                  href="<?= base_url('Ride/view/'.encode_param($ride->transport_id)) ?>">
                  <i class="fa fa-fw fa-edit"></i>Assign Driver
                </a>
              <?php } ?>
            </td>
          </tr>
      <?php } 
      }?>
    </tbody>
 </table>
</div>
</div>
</section>
</div>
