<div class="content-wrapper">
 <section class="content-header">
  <h1>
    <?= $page_title ?>
    <small><?= $page_desc ?></small>
  </h1>
  <ol class="breadcrumb">
   <li><a href="<?= base_url() ?>"><i class="fa fa-star-o" aria-hidden="true"></i>Home</a></li>
   <li><?= $menu ?></li>
   <li class="active"><?= $sub_menu ?></li>
 </ol>
</section>
<section class="content">
  <div class="row">
     <div class="col-md-12">
      <?php if($this->session->flashdata('message')) { 
        $flashdata = $this->session->flashdata('message'); ?>
        <div class="alert alert-<?= $flashdata['class'] ?>">
         <button class="close" data-dismiss="alert" type="button">×</button>
         <?= $flashdata['message'] ?>
       </div>
     <?php } ?>
   </div>
   <div class="col-md-12">
    <div class="box box-warning">
     <div class="box-header with-border">
       <h3 class="box-title">Edit Driver Details</h3>
     </div>
      <form role="form" action="<?=base_url('Vehicle/update/'.encode_param($vehicle_id))?>" method="post" class="validate" data-parsley-validate="" enctype="multipart/form-data">
        <div class="box-body">
          <div class="col-md-6">
           <div class="form-group has-feedback">
             <label for="exampleInputEmail1">Vehicle Type</label>
             <input type="text" class="form-control required" data-parsley-trigger="change"  
             data-parsley-minlength="2" data-parsley-pattern="^[a-zA-Z0-9\ . ! @ # $ % ^ & * () + = , \/]+$" required="" name="vehicle_type" value="<?= $vehicle_data->vehicle_type ?>" placeholder="Enter Company Name">
             <span class="glyphicon  form-control-feedback"></span>
           </div>
           <div class="col-md-12">          
            <div class="box-footer">
              <button type="submit" class="btn btn-primary">Submit</button>
            </div>        
          </div>     
        </div>
        <div class="col-md-6">
         <div class="form-group">
          <label for="exampleInputEmail1">Vehicle Photo</label>
          <div class="col-md-12">
            <div class="col-md-3">
              <img id="vehicle_photo" src="<?= base_url($vehicle_data->vehicle_photo) ?>" onerror="this.src='<?=base_url("assets/images/default_car.jpg")?>';" height="75" width="75" />
            </div>
            <div class="col-md-9" style="padding-top: 25px;">
              <input name="vehicle_photo" type="file" accept="image/*" onchange="setImg(this,'vehicle_photo');" />
            </div>
          </div>
        </div> 
        </div>
      </form>
    </div>
  </section>
</div>